package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.tile.dispenser.IBehaviorCollect;
import betterwithmods.api.tile.dispenser.IBehaviorEntity;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.blocks.behaviors.BehaviorBreakBlock;
import betterwithmods.common.blocks.behaviors.BehaviorDefaultDispenseBlock;
import betterwithmods.common.blocks.behaviors.BehaviorEntity;
import betterwithmods.common.blocks.tile.TileEntityBlockDispenser;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

import javax.annotation.Nullable;
import java.util.Optional;

public class BlockBDispenser extends BlockDispenser implements IMultiVariants {
    public static final RegistryDefaulted<Item, IBehaviorDispenseItem> BLOCK_DISPENSER_REGISTRY = new RegistryDefaulted<>(new BehaviorDefaultDispenseBlock());
    public static final RegistryDefaulted<Block, IBehaviorCollect> BLOCK_COLLECT_REGISTRY = new RegistryDefaulted<>(new BehaviorBreakBlock());
    public static final RegistryDefaulted<ResourceLocation, IBehaviorEntity> ENTITY_COLLECT_REGISTRY = new RegistryDefaulted<>(new BehaviorEntity());

    public BlockBDispenser() {
        super();
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(3.5F);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"facing=north,triggered=false"};
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K)
            return true;
        else {
            if (world.func_175625_s(pos) != null) {
                player.openGui(BWMod.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
    }

    private boolean isRedstonePowered(IBlockState state, World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing != state.func_177229_b(BlockDirectional.field_176387_N)) {
                BlockPos check = pos.func_177972_a(facing);
                if (world.func_175651_c(check, facing) > 0)
                    return true;
            }
        }
        return false;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos other) {
        boolean flag = isRedstonePowered(state, world, pos);
        boolean flag1 = state.func_177229_b(field_176440_b);
        if (flag && !flag1) {
            world.func_175684_a(pos, this, this.func_149738_a(world));
            world.func_180501_a(pos, state.func_177226_a(field_176440_b, true), 5);
        } else if (!flag && flag1) {
            world.func_175684_a(pos, this, this.func_149738_a(world));
            world.func_180501_a(pos, state.func_177226_a(field_176440_b, false), 5);
        }
    }

    private Optional<Entity> getEntity(World world, BlockPos pos) {
        return world.func_175647_a(Entity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)), Entity::func_70089_S).stream().findFirst();
    }

    @Override
    protected void func_176439_d(World world, BlockPos pos) {
        BlockSourceImpl impl = new BlockSourceImpl(world, pos);
        TileEntityBlockDispenser tile = impl.func_150835_j();
        if (!world.func_180495_p(pos).func_177229_b(field_176440_b)) {
            BlockPos check = pos.func_177972_a(impl.func_189992_e().func_177229_b(field_176441_a));
            Block block = world.func_180495_p(check).func_177230_c();

            if (world.func_180495_p(check).func_185887_b(world, check) < 0)
                return;
            IBehaviorCollect behavior = BLOCK_COLLECT_REGISTRY.func_82594_a(block);
            if (!world.func_175623_d(check) || !block.func_176200_f(world, check)) {
                NonNullList<ItemStack> stacks = behavior.collect(new BlockSourceImpl(world, check));
                InvUtils.insert(tile.inventory, stacks, false);
            }

            Optional<Entity> entity = getEntity(world, check);
            if (entity.isPresent()) {
                Entity e = entity.get();
                ResourceLocation name = EntityList.func_191301_a(e);
                IBehaviorEntity behaviorEntity = ENTITY_COLLECT_REGISTRY.func_82594_a(name);
                NonNullList<ItemStack> stacks = behaviorEntity.collect(world, check, e, tile.getCurrentSlot());
                InvUtils.insert(tile.inventory, stacks, false);
            }
        } else {
            int index = tile.nextIndex;
            ItemStack stack = tile.getNextStackFromInv();
            if (index == -1 || stack.func_190926_b())
                world.func_175718_b(1001, pos, 0);
            else {
                IBehaviorDispenseItem behavior = this.func_149940_a(stack);
                if (behavior != null) {

                    behavior.func_82482_a(impl, stack);
                }
            }
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBlockDispenser) {
            InvUtils.ejectInventoryContents(world, pos, ((TileEntityBlockDispenser) te).inventory);
            world.func_175666_e(pos, this);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    protected IBehaviorDispenseItem func_149940_a(@Nullable ItemStack stack) {
        return BLOCK_DISPENSER_REGISTRY.func_82594_a(stack == null ? null : stack.func_77973_b());
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBlockDispenser();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                return InvUtils.calculateComparatorLevel(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            }
        }
        return 0;
    }
}


