package betterwithmods.common.blocks;

import betterwithmods.api.tile.IRopeConnector;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.mechanical.BlockMechMachines.EnumType;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import static betterwithmods.util.DirUtils.FACING;

public class BlockAnchor extends BWMBlock implements IRopeConnector {
    public static final PropertyBool LINKED = PropertyBool.func_177716_a("linked");
    private static final float HEIGHT = 0.375F;

    private static final AxisAlignedBB D_AABB = new AxisAlignedBB(0.0F, 1.0F - HEIGHT, 0.0F, 1.0F, 1.0F, 1.0F);
    private static final AxisAlignedBB U_AABB = new AxisAlignedBB(0.0F, 0.0F, 0.0F, 1.0F, HEIGHT, 1.0F);
    private static final AxisAlignedBB N_AABB = new AxisAlignedBB(0.0F, 0.0F, 1.0F - HEIGHT, 1.0F, 1.0F, 1.0F);
    private static final AxisAlignedBB S_AABB = new AxisAlignedBB(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, HEIGHT);
    private static final AxisAlignedBB W_AABB = new AxisAlignedBB(1.0F - HEIGHT, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
    private static final AxisAlignedBB E_AABB = new AxisAlignedBB(0.0F, 0.0F, 0.0F, HEIGHT, 1.0F, 1.0F);
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{D_AABB, U_AABB, N_AABB, S_AABB, W_AABB, E_AABB};

    public BlockAnchor() {
        super(Material.field_151576_e);
        func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(2.0F);
        this.setHarvestLevel("pickaxe", 0);

    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = state.func_177229_b(FACING);
        return BOXES[facing.func_176745_a()];
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return this.setFacingInBlock(state, entity.func_70093_af() ? side.func_176734_d() : side);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a(FACING, facing);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        BlockPos down = pos.func_177977_b();

        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() instanceof ItemBlock) {
                Block block = ((ItemBlock) heldItem.func_77973_b()).func_179223_d();
                if (block == BWMBlocks.ROPE) {
                    if (!world.field_72995_K) {
                        if (world.func_180495_p(down).func_177230_c() == BWMBlocks.ROPE) {
                            BlockRope.placeRopeUnder(heldItem, world, down, player);
                        } else if (world.func_180495_p(down).func_177230_c().func_176200_f(world, down) || world.func_175623_d(down)) {
                            world.func_175656_a(down, BWMBlocks.ROPE.func_176223_P());
                            world.func_184133_a(null, down, BWMBlocks.ROPE.getSoundType(BWMBlocks.ROPE.func_176223_P(), world, null, null).func_185841_e(), SoundCategory.BLOCKS, 1, 1);
                            if (!player.field_71075_bZ.field_75098_d)
                                heldItem.func_190918_g(1);
                        } else
                            return false;
                    }
                    return true;
                }
            }
            return false;
        } else if (!world.field_72995_K) {
            if (retractRope(world, pos, player))
                world.func_184133_a(null, pos, BWMBlocks.ROPE.getSoundType(BWMBlocks.ROPE.func_176223_P(), world, null, null).func_185845_c(), SoundCategory.BLOCKS, 1, 1);
        }
        return true;
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing facing = getFacing(world.func_180495_p(pos));
        return side == facing.func_176734_d();
    }

    public EnumFacing getFacing(IBlockState state) {
        return state.func_177229_b(FACING);
    }

    private boolean retractRope(World world, BlockPos pos, EntityPlayer player) {
        for (int i = pos.func_177956_o() - 1; i >= 0; i--) {
            BlockPos pos2 = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (world.func_180495_p(pos2).func_177230_c() != BWMBlocks.ROPE && world.func_180495_p(pos2.func_177984_a()).func_177230_c() == BWMBlocks.ROPE) {
                if (!player.field_71075_bZ.field_75098_d)
                    addRopeToInv(world, pos, player);
                return world.func_175698_g(pos2.func_177984_a());
            } else if (world.func_180495_p(pos2).func_177230_c() != BWMBlocks.ROPE)
                return false;
        }
        return false;
    }

    private void addRopeToInv(World world, BlockPos pos, EntityPlayer player) {
        ItemStack rope = new ItemStack(BWMBlocks.ROPE);

        if (player.field_71071_by.func_70441_a(rope))
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.2F, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7F + 1.0F) * 2.0F);
        else
            InvUtils.ejectStackWithOffset(world, pos, rope);
    }

    @Override
    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityPlayer && world.func_180495_p(pos).func_177230_c() == this && world.func_180495_p(pos).func_177229_b(FACING) != EnumFacing.DOWN;
    }

    private boolean isRope(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == BWMBlocks.ROPE;
    }

    private boolean isAnchor(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == this && world.func_180495_p(pos).func_177229_b(FACING) != facing;
    }

    private boolean isPulley(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == BWMBlocks.SINGLE_MACHINES && world.func_180495_p(pos).func_177229_b(BlockMechMachines.TYPE) == EnumType.PULLEY;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = state.func_177229_b(FACING);
        boolean isConnected = facing == EnumFacing.UP ? isRope(world, pos, EnumFacing.UP) || isAnchor(world, pos, EnumFacing.UP) || isPulley(world, pos, EnumFacing.UP) : isRope(world, pos, EnumFacing.DOWN) || isAnchor(world, pos, EnumFacing.DOWN);
        return state.func_177226_a(LINKED, isConnected);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, EnumFacing.func_82600_a(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(FACING).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, FACING, LINKED);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == getFacing(state).func_176734_d() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}
