package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import javax.annotation.Nullable;

import static betterwithmods.common.blocks.BlockAesthetic.EnumType.HELLFIRE;

public class BlockAesthetic extends BWMBlock implements IMultiVariants {
    public static final PropertyEnum<BlockAesthetic.EnumType> TYPE = PropertyEnum.func_177709_a("blocktype", BlockAesthetic.EnumType.class);

    //Chopping Block, Chopping Block(dirty), Steel block, Hellfire block, Rope block, Flint block, Barrel (tile entity?) (6 - 11 subtypes)
    public BlockAesthetic() {
        super(Material.field_151576_e);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, BlockAesthetic.EnumType.CHOPBLOCK));
    }

    public static IBlockState getVariant(EnumType type) {
        return BWMBlocks.AESTHETIC.func_176223_P().func_177226_a(TYPE, type);
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.AESTHETIC, 1, type.getMeta());
    }

    public static ItemStack getStack(EnumType type, int amount) {
        return new ItemStack(BWMBlocks.AESTHETIC, amount, type.getMeta());
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return state.func_177229_b(TYPE).getHardness();
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return state.func_177229_b(TYPE).getSoundType();
    }

    @Override
    public Material func_149688_o(IBlockState state) {
        return state.func_177229_b(TYPE).getMaterial();
    }

    @Override
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177229_b(TYPE).getMapColor();
    }

    @Override
    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return world.func_180495_p(pos).func_177229_b(TYPE).getResistance();
    }

    @Override
    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"blocktype=chopping", "blocktype=chopping_blood", "blocktype=nether_clay", "blocktype=hellfire", "blocktype=rope", "blocktype=flint", "blocktype=whitestone", "blocktype=whitecobble", "blocktype=enderblock", "blocktype=padding", "blocktype=soap", "blocktype=dung", "blocktype=wicker", "blocktype=nethercoal"};
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            if(!type.name.equalsIgnoreCase("unused"))
                items.add(getStack(type));
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (state.func_177229_b(TYPE)).getMeta();
    }

    @Override
    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return (world.func_180495_p(pos).func_177229_b(TYPE)) == HELLFIRE;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, BlockAesthetic.EnumType.byMeta(meta));
    }


    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(TYPE).getMeta();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, TYPE);
    }

    public enum EnumType implements IStringSerializable {
        CHOPBLOCK(0, "chopping", MapColor.field_151665_m),
        CHOPBLOCKBLOOD(1, "chopping_blood", MapColor.field_151655_K),
        NETHERCLAY(2, "nether_clay", MapColor.field_151655_K),
        HELLFIRE(3, "hellfire", MapColor.field_151676_q),
        ROPE(4, "rope", MapColor.field_151664_l, Material.field_151580_n, SoundType.field_185854_g, 1F, 5F),
        FLINT(5, "flint", MapColor.field_151665_m),
        WHITESTONE(6, "whitestone", MapColor.field_151659_e),
        WHITECOBBLE(7, "whitecobble", MapColor.field_151659_e),
        ENDERBLOCK(8, "enderblock", MapColor.field_151679_y),
        PADDING(9, "padding", MapColor.field_151659_e, Material.field_151580_n, SoundType.field_185854_g, 1F, 5F),
        SOAP(10, "soap", MapColor.field_151671_v, Material.field_151578_c, SoundType.field_185849_b, 1F, 5F),
        DUNG(11, "dung", MapColor.field_151650_B, Material.field_151578_c, SoundType.field_185849_b, 1F, 2F),
        WICKER(12, "wicker", MapColor.field_151650_B, Material.field_151575_d, SoundType.field_185848_a, 1F, 5F),
        NETHERCOAL(13, "nethercoal", MapColor.field_151645_D, Material.field_151591_t, SoundType.field_185851_d, 5.0F,10.0F);

        private static final BlockAesthetic.EnumType[] VALUES = values();

        private final int meta;
        private final String name;
        private final MapColor color;
        private final Material material;
        private final SoundType soundType;
        private final float hardness;
        private final float resistance;

        EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.color = color;
            this.material = Material.field_151576_e;
            this.soundType = SoundType.field_185851_d;
            this.hardness = 1.5F;
            this.resistance = 10F;
        }

        EnumType(int meta, String name, MapColor color, Material material, SoundType soundType, float hardness, float resistance) {
            this.meta = meta;
            this.name = name;
            this.color = color;
            this.material = material;
            this.soundType = soundType;
            this.hardness = hardness;
            this.resistance = resistance;
        }


        public static BlockAesthetic.EnumType byMeta(int meta) {
            return VALUES[meta];
        }

        @Override
        public String func_176610_l() {
            return name;
        }

        public int getMeta() {
            return meta;
        }

        public MapColor getMapColor() {
            return color;
        }

        public Material getMaterial() {
            return material;
        }

        public SoundType getSoundType() {
            return soundType;
        }

        public float getHardness() {
            return hardness;
        }

        public float getResistance() {
            return resistance;
        }
    }
}
