package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.client.BWParticleDigging;
import betterwithmods.client.baking.IStateParticleBakedModel;
import betterwithmods.common.blocks.mini.BlockMini;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.util.item.ToolsManager;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;

public abstract class BWMBlock extends Block {
    public BWMBlock(Material material) {
        super(material);
        func_149647_a(BWCreativeTabs.BWTAB);
        if (material == Material.field_151575_d || material == BlockMini.MINI) {
            ToolsManager.setAxesAsEffectiveAgainst(this);
            this.func_149672_a(SoundType.field_185848_a);
            this.setHarvestLevel("axe", 0);
        } else if (material == Material.field_151576_e) {
            this.func_149672_a(SoundType.field_185851_d);
            setHarvestLevel("pickaxe", 1);
            ToolsManager.setPickaxesAsEffectiveAgainst(this);
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TileBasic) {
            ((TileBasic) worldIn.func_175625_s(pos)).onBreak();
            worldIn.func_175666_e(pos, this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        onBlockPlacedBy(world, pos, state, placer, stack, null, 0.5f, 0.5f, 0.5f);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, @Nullable EnumFacing face, float hitX, float hitY, float hitZ) {
        if (hasTileEntity(state)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileBasic) {
                ((TileBasic) tile).onPlacedBy(placer, face, stack, hitX, hitY, hitZ);
            }
        }
    }


    @Override
    @SideOnly(Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleBakedModel) {
            state = getExtendedState(state.func_185899_b(world, pos), world, pos);
            TextureAtlasSprite sprite = ((IStateParticleBakedModel) model).getParticleTexture(state, null);
            if (sprite != null) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        for (int l = 0; l < 4; ++l) {
                            double d0 = ((double) j + 0.5D) / 4.0D;
                            double d1 = ((double) k + 0.5D) / 4.0D;
                            double d2 = ((double) l + 0.5D) / 4.0D;
                            manager.func_78873_a(new BWParticleDigging(world, (double) pos.func_177958_n() + d0, (double) pos.func_177956_o() + d1, (double) pos.func_177952_p() + d2, d0 - 0.5D, d1 - 0.5D, d2 - 0.5D, state, pos, sprite, getParticleTintIndex()));
                        }
                    }
                }

                return true;
            }
        }

        return super.addDestroyEffects(world, pos, manager);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleBakedModel) {
            BlockPos pos = target.func_178782_a();
            EnumFacing side = target.field_178784_b;

            state = getExtendedState(state.func_185899_b(world, pos), world, pos);
            TextureAtlasSprite sprite = ((IStateParticleBakedModel) model).getParticleTexture(state, side);
            if (sprite != null) {
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_185900_c(world, pos);
                double d0 = (double) i + RANDOM.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.20000000298023224D) + 0.10000000149011612D + axisalignedbb.field_72340_a;
                double d1 = (double) j + RANDOM.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.20000000298023224D) + 0.10000000149011612D + axisalignedbb.field_72338_b;
                double d2 = (double) k + RANDOM.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.20000000298023224D) + 0.10000000149011612D + axisalignedbb.field_72339_c;

                if (side == EnumFacing.DOWN) {
                    d1 = (double) j + axisalignedbb.field_72338_b - 0.10000000149011612D;
                }

                if (side == EnumFacing.UP) {
                    d1 = (double) j + axisalignedbb.field_72337_e + 0.10000000149011612D;
                }

                if (side == EnumFacing.NORTH) {
                    d2 = (double) k + axisalignedbb.field_72339_c - 0.10000000149011612D;
                }

                if (side == EnumFacing.SOUTH) {
                    d2 = (double) k + axisalignedbb.field_72334_f + 0.10000000149011612D;
                }

                if (side == EnumFacing.WEST) {
                    d0 = (double) i + axisalignedbb.field_72340_a - 0.10000000149011612D;
                }

                if (side == EnumFacing.EAST) {
                    d0 = (double) i + axisalignedbb.field_72336_d + 0.10000000149011612D;
                }

                Particle particle = new BWParticleDigging(world, d0, d1, d2, 0.0D, 0.0D, 0.0D, state, pos, sprite, getParticleTintIndex())
                        .func_70543_e(0.2F)
                        .func_70541_f(0.6F);
                manager.func_78873_a(particle);

                return true;
            }
        }

        return false;
    }

    @Override
    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState stateAgain, EntityLivingBase entity, int numberOfParticles) {
        //TODO
//        PacketCustomBlockDust packet = new PacketCustomBlockDust(world, pos, entity.posX, entity.posY, entity.posZ, numberOfParticles, 0.15f);
//        CharsetLib.packet.sendToDimension(packet, world.provider.getDimension());
        return super.addLandingEffects(state, world, pos, stateAgain, entity, numberOfParticles);
    }

    @Override
    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return super.addRunningEffects(state, world, pos, entity);
//        return UtilProxyCommon.proxy.addRunningParticles(state, world, pos, entity);

    }

    public int getParticleTintIndex() {
        return -1;
    }
}
