package betterwithmods.common;

import betterwithmods.BWMod;
import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityAxle;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.common.blocks.behaviors.BehaviorDiodeDispense;
import betterwithmods.common.blocks.behaviors.BehaviorSilkTouch;
import betterwithmods.common.entity.*;
import betterwithmods.common.entity.item.EntityFallingBlockCustom;
import betterwithmods.common.penalties.PenaltyHandlerRegistry;
import betterwithmods.common.potion.BWPotion;
import betterwithmods.common.potion.PotionSlowfall;
import betterwithmods.common.potion.PotionTruesight;
import betterwithmods.common.registry.BellowsManager;
import betterwithmods.common.registry.HopperFilters;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.block.managers.KilnManagerBlock;
import betterwithmods.common.registry.block.managers.SawManagerBlock;
import betterwithmods.common.registry.block.managers.TurntableManagerBlock;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.StateIngredient;
import betterwithmods.common.registry.bulk.manager.CookingPotManager;
import betterwithmods.common.registry.bulk.manager.MillManager;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import betterwithmods.manual.api.API;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.compat.Quark;
import betterwithmods.module.compat.bop.BiomesOPlenty;
import betterwithmods.module.gameplay.CraftingRecipes;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.hardcore.crafting.*;
import betterwithmods.module.hardcore.creatures.EntityTentacle;
import betterwithmods.module.hardcore.needs.HCTools;
import betterwithmods.module.hardcore.world.HCTorches;
import betterwithmods.network.BWNetwork;
import betterwithmods.util.DispenserBehaviorDynamite;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressWarnings("unused")
@Mod.EventBusSubscriber(modid = BWMod.MODID)
public class BWRegistry {

    public static final PenaltyHandlerRegistry PENALTY_HANDLERS = new PenaltyHandlerRegistry();

    public static final CookingPotManager CAULDRON = new CookingPotManager();
    public static final CookingPotManager CRUCIBLE = new CookingPotManager();
    public static final MillManager MILLSTONE = new MillManager();
    public static final SawManagerBlock WOOD_SAW = new SawManagerBlock();
    public static final KilnManagerBlock KILN = new KilnManagerBlock();
    public static final TurntableManagerBlock TURNTABLE = new TurntableManagerBlock();
    public static final HopperFilters HOPPER_FILTERS = new HopperFilters();

    @GameRegistry.ObjectHolder("betterwithmods:true_sight")
    public static final Potion POTION_TRUESIGHT = null;
    @GameRegistry.ObjectHolder("betterwithmods:fortune")
    public static final Potion POTION_FORTUNE = null;
    @GameRegistry.ObjectHolder("betterwithmods:looting")
    public static final Potion POTION_LOOTING = null;
    @GameRegistry.ObjectHolder("betterwithmods:slow_fall")
    public static final Potion POTION_SLOWFALL = null;

    private static int availableEntityId = 0;

    static {
        BWMAPI.IMPLEMENTATION = new MechanicalUtil();
    }

    public static void preInit() {
        API.manualAPI = ManualDefinitionImpl.INSTANCE;
        BWNetwork.registerNetworking();
        BWMBlocks.registerBlocks();
        BWMItems.registerItems();
        BWMBlocks.registerTileEntities();
        BWRegistry.registerEntities();
        BWRegistry.registerBlockDispenserBehavior();
        CapabilityManager.INSTANCE.register(IMechanicalPower.class, new CapabilityMechanicalPower.Impl(), CapabilityMechanicalPower.Default::new);
        CapabilityManager.INSTANCE.register(IAxle.class, new CapabilityAxle.Impl(), CapabilityAxle.Default::new);
        KilnStructureManager.registerKilnBlock(Blocks.field_150336_V.func_176223_P());
        KilnStructureManager.registerKilnBlock(Blocks.field_150385_bj.func_176223_P());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BWMBlocks.getBlocks().forEach(event.getRegistry()::register);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        BWMItems.getItems().forEach(event.getRegistry()::register);
    }

    @SubscribeEvent(priority = EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry<IRecipe> reg = (ForgeRegistry<IRecipe>) event.getRegistry();

        for(IRecipe recipe: BWMRecipes.getRecipes()) {
            event.getRegistry().register(recipe);
        }

        for (IRecipe recipe : reg) {
            for(Pattern pattern: BWMRecipes.REMOVE_BY_REGEX) {
                Matcher matcher = pattern.matcher(recipe.getRegistryName().toString());
                if(matcher.matches()) {
                    reg.remove(recipe.getRegistryName());
                }
            }
            for (ResourceLocation loc : BWMRecipes.REMOVE_RECIPE_BY_RL) {
                if (loc.equals(recipe.getRegistryName()))
                    reg.remove(recipe.getRegistryName());
            }
            for (ItemStack output : BWMRecipes.REMOVE_RECIPE_BY_OUTPUT) {
                if (InvUtils.matches(recipe.func_77571_b(), output)) {
                    reg.remove(recipe.getRegistryName());
                }
            }
            for (List<Ingredient> inputs : BWMRecipes.REMOVE_RECIPE_BY_INPUT) {
                if (InvUtils.containsIngredient(recipe.func_192400_c(), inputs)) {
                    reg.remove(recipe.getRegistryName());
                }
            }
        }
    }

    public static void init() {
        BWRegistry.registerHeatSources();
        BWOreDictionary.registerOres();
    }

    public static void postInit() {
        BWOreDictionary.postInitOreDictGathering();
        BellowsManager.postInit();
    }

    public static void postPostInit() {
        registerRecipes();
    }

    /**
     * All names should be snake_case by convention (enforced in 1.11).
     */
    private static void registerEntities() {
        BWRegistry.registerEntity(EntityExtendingRope.class, "extending_rope", 64, 20, true);
        BWRegistry.registerEntity(EntityDynamite.class, "bwm_dynamite", 10, 50, true);
        BWRegistry.registerEntity(EntityUrn.class, "bwm_urn", 10, 50, true);
        BWRegistry.registerEntity(EntityMiningCharge.class, "bwm_mining_charge", 10, 50, true);
        BWRegistry.registerEntity(EntityShearedCreeper.class, "entity_sheared_creeper", 64, 1, true);
        BWRegistry.registerEntity(EntityBroadheadArrow.class, "entity_broadhead_arrow", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingGourd.class, "entity_falling_gourd", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingBlockCustom.class, "falling_block_custom", 64, 20, true);
        BWRegistry.registerEntity(EntitySpiderWeb.class, "bwm_spider_web", 64, 20, true);
        BWRegistry.registerEntity(EntityHCFishHook.class, "bwm_fishing_hook", 64, 20, true);
        BWRegistry.registerEntity(EntityTentacle.class, "bwm_tentacle", 64, 1, true);

        BWRegistry.registerEntity(EntityJungleSpider.class, "bwm_jungle_spider", 64, 1, true, 0x3C6432, 0x648C50 );
    }

    public static void registerBlockDispenserBehavior() {
        BlockDispenser.field_149943_a.func_82595_a(BWMItems.DYNAMITE, new DispenserBehaviorDynamite());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a(BWMItems.DYNAMITE, new DispenserBehaviorDynamite());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a(Items.field_151107_aW, new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a(Items.field_151132_bS, new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a(Item.func_150898_a(BWMBlocks.MINING_CHARGE),
                (source, stack) -> {
                    World worldIn = source.func_82618_k();
                    EnumFacing facing = source.func_189992_e().func_177229_b(BlockDispenser.field_176441_a);
                    BlockPos pos = source.func_180699_d().func_177972_a(facing);
                    EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, pos.func_177958_n() + 0.5F, pos.func_177956_o(),
                            pos.func_177952_p() + 0.5F, null, facing);
                    miningCharge.func_189654_d(false);
                    worldIn.func_72838_d(miningCharge);
                    worldIn.func_184148_a(null, miningCharge.field_70165_t, miningCharge.field_70163_u, miningCharge.field_70161_v,
                            SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0F, 1.0F);
                    return stack;
                });
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a(Blocks.field_150348_b, new BehaviorSilkTouch());
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a(Blocks.field_150364_r, new BehaviorSilkTouch());
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a(Blocks.field_150363_s, new BehaviorSilkTouch());


        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(new ResourceLocation("minecraft:sheep"), (world, pos, entity, stack) -> {
            EntitySheep sheep = (EntitySheep) entity;
            if (sheep.isShearable(new ItemStack(Items.field_151097_aZ), world, pos)) {
                return InvUtils.asNonnullList(sheep.onSheared(new ItemStack(Items.field_151097_aZ), world, pos, 0));
            }
            return NonNullList.func_191196_a();
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(new ResourceLocation("minecraft:chicken"), (world, pos, entity, stack) -> {
            if (((EntityAgeable) entity).func_70631_g_())
                return NonNullList.func_191196_a();
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151008_G, 1 + world.field_73012_v.nextInt(2)));
            world.func_184133_a(null, pos, SoundEvents.field_187666_Z, SoundCategory.NEUTRAL, 0.75F, 1.0F);
            entity.func_70106_y();
            return InvUtils.asNonnullList(new ItemStack(Items.field_151110_aK));
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(new ResourceLocation("minecraft:cow"), (world, pos, entity, stack) -> {
            if (((EntityAgeable) entity).func_70631_g_())
                return NonNullList.func_191196_a();
            if (stack.func_77969_a(new ItemStack(Items.field_151133_ar))) {
                stack.func_190918_g(1);
                world.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.BLOCKS, 1.0F, 1.0F);

                InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151117_aB));
            }
            return NonNullList.func_191196_a();
        });
    }

    /**
     * Registers an entity for this mod. Handles automatic available ID
     * assignment.
     */
    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange,
                                      int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(new ResourceLocation(BWMod.MODID, entityName), entityClass, entityName, availableEntityId, BWMod.instance, trackingRange,
                updateFrequency, sendsVelocityUpdates);
        availableEntityId++;
    }


    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity(new ResourceLocation(BWMod.MODID, entityName), entityClass, entityName, availableEntityId, BWMod.instance, trackingRange,
                updateFrequency, sendsVelocityUpdates, primaryColor, secondaryColor);
        availableEntityId++;
    }

    public static void registerHeatSources() {
        BWMHeatRegistry.addHeatSource(new StateIngredient(Blocks.field_150480_ab, Items.field_190931_a), 1);
        BWMHeatRegistry.addHeatSource(new StateIngredient(BWMBlocks.STOKED_FLAME, Items.field_190931_a), 2);
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register(registerPotion(new PotionTruesight("true_sight", true, 14270531).func_76399_b(4, 1)));
        event.getRegistry().register(registerPotion(new BWPotion("fortune", true, 14270531).func_76399_b(5, 2)));
        event.getRegistry().register(registerPotion(new BWPotion("looting", true, 14270531).func_76399_b(6, 2)));
        event.getRegistry().register(registerPotion(new PotionSlowfall("slow_fall", true, 0xF46F20).func_76399_b(4, 1)));
    }

    private static Potion registerPotion(Potion potion) {
        String potionName = potion.getRegistryName().func_110623_a();
        potion.func_76390_b("bwm.effect." + potionName);
        return potion;
    }

    private static void registerFireInfo() {
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WOODEN_AXLE, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WOODEN_BROKEN_GEARBOX, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WOODEN_GEARBOX, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WINDMILL, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.WATERWHEEL, 5, 20);
        Blocks.field_150480_ab.func_180686_a(BWMBlocks.VINE_TRAP, 5, 20);
        //TODO 1.13 block of nethercoal

        registerFireInfo(new BlockIngredient("blockCandle"), 5, 20);
        registerFireInfo(new BlockIngredient("slats"), 5, 20);
        registerFireInfo(new BlockIngredient("grates"), 5, 20);
    }

    public static void registerFireInfo(BlockIngredient ingredient, int encouragement, int flammability) {
        for (IBlockState state : ingredient.getStates()) {
            Blocks.field_150480_ab.func_180686_a(state.func_177230_c(), encouragement, flammability);
        }
    }

    public static void registerRecipes() {
        ForgeRegistry<IRecipe> reg = (ForgeRegistry<IRecipe>) ForgeRegistries.RECIPES;

        replaceIRecipe(CraftingRecipes.class, reg);
        replaceIRecipe(HCTools.class, reg);
        replaceIRecipe(HCDiamond.class, reg);
        replaceIRecipe(HCLumber.class, reg);
        replaceIRecipe(HCOres.class, reg);
        replaceIRecipe(HCRedstone.class, reg);
        replaceIRecipe(HCTorches.class, reg);
        replaceIRecipe(HCFishing.class, reg);
        replaceIRecipe(MiniBlocks.class, reg);

        replaceIRecipe(BiomesOPlenty.class, reg);
        replaceIRecipe(Quark.class, reg);
    }

    private static void retrieveRecipes(String category, ForgeRegistry<IRecipe> reg) {
        List<IRecipe> recipes = BWMRecipes.getHardcoreRecipes(category);
        if (recipes != null) {
            for (IRecipe recipe : recipes) {
                ResourceLocation location = recipe.getRegistryName();
                if (reg.containsKey(location))
                    registerReplacements(reg.getValue(location), recipe);
                else
                    reg.register(recipe);
            }
        }
    }

    private static void replaceIRecipe(Class<? extends Feature> clazz, IForgeRegistry<IRecipe> reg) {
        if (ModuleLoader.isFeatureEnabled(clazz)) {
            List<IRecipe> recipes = BWMRecipes.getHardcoreRecipes(clazz.getSimpleName());
            if (recipes != null) {
                recipes.forEach(reg::register);
            }
        }
    }

    private static void registerReplacements(IRecipe original, IRecipe from) {
        NonNullList<Ingredient> ing = original.func_192400_c();
        for (int i = 0; i < ing.size(); i++) {
            ing.set(i, from.func_192400_c().get(i));
        }
    }
}

