package betterwithmods.client.tesr;

import betterwithmods.BWMod;
import betterwithmods.client.model.ModelWaterwheel;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWaterwheel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class TESRWaterwheel extends TileEntitySpecialRenderer<TileEntityWaterwheel> {

    public static final ResourceLocation WATERWHEEL = new ResourceLocation(BWMod.MODID,"textures/blocks/waterwheel.png");

    private final ModelWaterwheel waterwheel;

    public TESRWaterwheel() {
        this.waterwheel = new ModelWaterwheel();
    }

    @Override
    public void func_192841_a(TileEntityWaterwheel te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        BlockPos pos = te.getBlockPos();
        RenderUtils.renderDebugBoundingBox(x,y,z,te.getRenderBoundingBox().func_72317_d(-pos.func_177958_n(),-pos.func_177956_o(),-pos.func_177952_p()));

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(x + 0.5D, y + 0.5D, z + 0.5D);
        this.func_147499_a(WATERWHEEL);
        EnumFacing dir = te.getOrientation();
        float rotation = (te.getCurrentRotation() + (te.getMaximumInput(dir) == 0 ? 0 : partialTicks * te.getPrevRotation()));

        if (dir == EnumFacing.EAST) {
            waterwheel.setRotateAngle(waterwheel.axle, 0, 0, (float) Math.toRadians(rotation));
            GlStateManager.func_179114_b(90.0F, 0.0F, 1.0F, 0.0F);
        } else if (dir == EnumFacing.SOUTH) {
            waterwheel.setRotateAngle(waterwheel.axle, 0, 0, -(float) Math.toRadians(rotation));
        } else {
            waterwheel.setRotateAngle(waterwheel.axle, 0, (float) Math.toRadians(rotation), 0);
            GlStateManager.func_179114_b(90.0F, 1.0F, 0.0F, 0.0F);
        }

        this.waterwheel.render(0.0625F);
        GlStateManager.func_179121_F();
    }

}
