package betterwithmods.client.tesr;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileSteelSaw;
import betterwithmods.util.DirUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TESRSteelSaw extends TileEntitySpecialRenderer<TileSteelSaw> {

    @Override
    public void func_192841_a(TileSteelSaw te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = func_178459_a().func_180495_p(te.getBlockPos());
        if (state.func_177230_c() != BWMBlocks.STEEL_SAW)
            return;
        boolean active = state.func_177229_b(IBlockActive.ACTIVE);
        EnumFacing.Axis axis = state.func_177229_b(DirUtils.AXIS);
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        {
            GlStateManager.func_179137_b(x, y, z);
            GlStateManager.func_179101_C();
            GlStateManager.func_179094_E();
            {
                IBlockState axle = BWMBlocks.STEEL_AXLE.func_176223_P().func_177226_a(DirUtils.AXIS, axis).func_177226_a(IBlockActive.ACTIVE, active);
                renderBlock(te, axle);
            }

            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            {

                GlStateManager.func_179137_b(0.5, 0.5, 0.5);
                if (active) {
                    long angle = (axis != EnumFacing.Axis.Z ? -1 : 1) * (System.currentTimeMillis() / 3) % 360;

                    switch (axis) {

                        case X:
                            GlStateManager.func_179114_b(angle, 1, 0, 0);
                            break;
                        case Y:
                            GlStateManager.func_179114_b(angle, 0, 1, 0);
                            break;
                        case Z:
                            GlStateManager.func_179114_b(angle, 0, 0, 1);
                            break;
                    }

                }
                GlStateManager.func_179137_b(-0.5, -0.5, -0.5);
                renderBlock(te, state);


            }
            GlStateManager.func_179121_F();

        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    public void renderBlock(TileSteelSaw te, IBlockState state) {
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j(GL11.GL_SMOOTH);
        } else {
            GlStateManager.func_179103_j(GL11.GL_FLAT);
        }

        World world = te.getBlockWorld();
        GlStateManager.func_179109_b(-te.getBlockPos().func_177958_n(), -te.getBlockPos().func_177956_o(), -te.getBlockPos().func_177952_p());

        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);

        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(state);
        dispatcher.func_175019_b().func_178267_a(world, model, state, te.getBlockPos(), bufferBuilder, true);
        tessellator.func_78381_a();

        RenderHelper.func_74519_b();
    }

    @Override
    public boolean func_188185_a(TileSteelSaw te) {
        return true;
    }
}
