package betterwithmods.client.render;

import betterwithmods.module.hardcore.creatures.EntityTentacle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class RenderTentacle extends Render<EntityTentacle> {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/particle/particles.png");

    public RenderTentacle(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    /**
     * Renders the desired {@code T} type Entity.
     */
    public void func_76986_a(EntityTentacle entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntityLivingBase angler = entity.getAngler();

        if (angler != null && !this.field_188301_f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((float) x + 0.5, (float) y + 0.5, (float) z + 0.5);
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a(0.5F, 0.5F, 0.5F);
            this.func_180548_c(entity);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();

            GlStateManager.func_179114_b(180.0F - this.field_76990_c.field_78735_i, 0.0F, 1.0F, 0.0F);
            GlStateManager.func_179114_b((float) (this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j, 1.0F, 0.0F, 0.0F);

            if (this.field_188301_f) {
                GlStateManager.func_179142_g();
                GlStateManager.func_187431_e(this.func_188298_c(entity));
            }

            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            bufferbuilder.func_181662_b(-0.5D, -0.5D, 0.0D).func_187315_a(0.0625D, 0.1875D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
            bufferbuilder.func_181662_b(0.5D, -0.5D, 0.0D).func_187315_a(0.125D, 0.1875D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
            bufferbuilder.func_181662_b(0.5D, 0.5D, 0.0D).func_187315_a(0.125D, 0.125D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
            bufferbuilder.func_181662_b(-0.5D, 0.5D, 0.0D).func_187315_a(0.0625D, 0.125D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
            tessellator.func_78381_a();

            if (this.field_188301_f) {
                GlStateManager.func_187417_n();
                GlStateManager.func_179119_h();
            }

            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();

            float f7 = angler.func_70678_g(partialTicks);
            float f8 = MathHelper.func_76126_a(MathHelper.func_76129_c(f7) * (float) Math.PI);
            float f9 = (angler.field_70760_ar + (angler.field_70761_aq - angler.field_70760_ar) * partialTicks) * 0.017453292F;
            double d0 = (double) MathHelper.func_76126_a(f9);
            double d1 = (double) MathHelper.func_76134_b(f9);
            double d4;
            double d5;
            double d6;
            double d7;


            d4 = angler.field_70169_q + (angler.field_70165_t - angler.field_70169_q);// * (double) partialTicks - d0 * 0.8D;
            d5 = angler.field_70167_r + (double) angler.func_70047_e() + (angler.field_70163_u - angler.field_70167_r) * (double) partialTicks - 0.15D;
            d6 = angler.field_70166_s + (angler.field_70161_v - angler.field_70166_s);// * (double) partialTicks + d1 * 0.8D;
            d7 = angler.func_70093_af() ? -0.1875D : 0.0D;


            double d13 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double) partialTicks;
            double d8 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double) partialTicks + 0.25D;
            double d9 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double) partialTicks;
            double d10 = (double) ((float) (d4 - d13));
            double d11 = (double) ((float) (d5 - d8)) + d7;
            double d12 = (double) ((float) (d6 - d9));
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);

            for (int i1 = 0; i1 <= 16; ++i1) {
                float f11 = (float) i1 / 16.0F;
                bufferbuilder.func_181662_b(x + d10 * (double) f11, y + d11 * (double) (f11 * f11 + f11) * 0.5D + 0.25D, z + d12 * (double) f11).func_181669_b(0, 0, 0, 255).func_181675_d();
            }

            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    /**
     * Returns the location of an entity's texture. Doesn't seem to be called unless you call Render.bindEntityTexture.
     */
    protected ResourceLocation func_110775_a(EntityTentacle entity) {
        return FISH_PARTICLES;
    }
}
