package betterwithmods.client.render;

import betterwithmods.BWMod;
import betterwithmods.client.model.ModelLongBoi;
import betterwithmods.common.entity.EntityLongboi;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;

public class RenderLongboi extends RenderLiving<EntityLongboi> {
    private static final ResourceLocation WOLF_TEXTURES = new ResourceLocation(BWMod.MODID, "textures/entity/wild_boi.png");
    private static final ResourceLocation TAMED_WOLF_TEXTURES = new ResourceLocation(BWMod.MODID, "textures/entity/long_boi.png");
    private static final ResourceLocation ANRGY_WOLF_TEXTURES = new ResourceLocation(BWMod.MODID, "textures/entity/mad_boi.png");

    public RenderLongboi(RenderManager manager) {
        super(manager, new ModelLongBoi(), 0.5F);
        this.func_177094_a(new LayerCollar(this));
    }

    /**
     * Defines what float the third param in setRotationAngles of ModelBase is
     */
    protected float func_77044_a(EntityLongboi livingBase, float partialTicks) {
        return livingBase.func_70920_v();
    }

    /**
     * Renders the desired {@code T} type Entity.
     */
    public void func_76986_a(EntityLongboi entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.func_70921_u()) {
            float f = entity.func_70013_c() * entity.func_70915_j(partialTicks);
            GlStateManager.func_179124_c(f, f, f);
        }
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    /**
     * Returns the location of an entity's texture. Doesn't seem to be called unless you call Render.bindEntityTexture.
     */
    protected ResourceLocation func_110775_a(EntityLongboi entity) {
        if (entity.func_70909_n()) {
            return TAMED_WOLF_TEXTURES;
        } else {
            return entity.func_70919_bu() ? ANRGY_WOLF_TEXTURES : WOLF_TEXTURES;
        }
    }
}
