package betterwithmods.client.render;

import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.client.tesr.TESRBucket;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBucket;
import betterwithmods.common.blocks.tile.TileEntityBucket;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.util.AABBArray;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * @author mrebhan
 */

public class RenderExtendingRope extends Render<EntityExtendingRope> {

    public RenderExtendingRope(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    protected ResourceLocation func_110775_a(EntityExtendingRope entity) {
        return null;
    }

    @Override
    public void func_76986_a(EntityExtendingRope entity, double x, double y, double z, float entityYaw,
                         float partialTicks) {
        World world = entity.func_130014_f_();
        IBlockState iblockstate = BWMBlocks.ROPE.func_176223_P();
        this.func_110776_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();

        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockPos blockpos = new BlockPos(entity.field_70165_t, entity.func_174813_aQ().field_72337_e, entity.field_70161_v);
        GlStateManager.func_179137_b(x - blockpos.func_177958_n() - 0.5, (float) (y - (double) blockpos.func_177956_o()), z - blockpos.func_177952_p() - 0.5);
        GlStateManager.func_179137_b(-0.005, 0, -0.005);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();

        int i = 0;
        while (entity.getPulleyPosition().func_177956_o() - entity.field_70163_u > i && i < 2) {
            blockrendererdispatcher.func_175019_b().func_187493_a(world,
                    blockrendererdispatcher.func_184389_a(iblockstate), iblockstate, blockpos.func_177981_b(i), vertexbuffer,
                    false, 0);
            i++;
        }

        entity.getBlocks().forEach((vec, state) -> {
            blockrendererdispatcher.func_175019_b().func_187493_a(world,
                    blockrendererdispatcher.func_184389_a(state), state, blockpos.func_177971_a(vec), vertexbuffer, false, 0);
            if (state.func_177230_c() instanceof BlockBucket) {
                if (entity.getTiles().containsKey(vec)) {
                    TileEntityBucket bucket = new TileEntityBucket();
                    NBTTagCompound tag = entity.getTiles().get(vec);
                    bucket.func_145839_a(tag);
                    new TESRBucket().func_192841_a(bucket, x, y, z, partialTicks, 0, 0);
                }
            }

        });

        tessellator.func_78381_a();

        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();

        RenderUtils.renderDebugBoundingBox(x,y,z,AABBArray.getParts(entity.func_174813_aQ().func_72317_d(-entity.field_70165_t,-entity.field_70163_u,-entity.field_70161_v)));

        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

}
