package betterwithmods.client.model.render;

import betterwithmods.BWMod;
import betterwithmods.client.model.filters.*;
import betterwithmods.common.BWMBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.lwjgl.opengl.GL11;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Function;

public class RenderUtils {
    public static final Function<ResourceLocation, TextureAtlasSprite> textureGetter = ModelLoader.defaultTextureGetter();
    protected static final Minecraft minecraft = Minecraft.func_71410_x();
    public static float FLUID_OFFSET = 0.005f;
    private static HashMap<String, ModelWithResource> filterLocations = new HashMap<>();
    private static RenderItem renderItem;

    public static String fromStack(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString() + ":" + stack.func_77960_j();
    }

    public static boolean filterContains(ItemStack stack) {
        return !stack.func_190926_b() && filterLocations.containsKey(fromStack(stack));
    }

    public static ModelWithResource getModelFromStack(ItemStack stack) {
        if (filterContains(stack))
            return filterLocations.get(fromStack(stack));
        return null;
    }

    public static void addFilter(ItemStack stack, ModelWithResource resource) {
        filterLocations.put(fromStack(stack), resource);
    }

    public static void registerFilters() {
        String[] woodTypes = {"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
        for (int i = 0; i < 6; i++) {
            addFilter(new ItemStack(BWMBlocks.SLATS, 1, i), new ModelSlats(new ResourceLocation(BWMod.MODID, "textures/blocks/wood_side_" + woodTypes[i] + ".png")));
            addFilter(new ItemStack(BWMBlocks.GRATE, 1, i), new ModelGrate(new ResourceLocation(BWMod.MODID, "textures/blocks/wood_side_" + woodTypes[i] + ".png")));
        }
        addFilter(new ItemStack(BWMBlocks.WICKER, 1, 2), new ModelOpaque(new ResourceLocation(BWMod.MODID, "textures/blocks/wicker.png")));
        addFilter(new ItemStack(Blocks.field_150425_aM), new ModelOpaque(new ResourceLocation("minecraft", "textures/blocks/soul_sand.png")));
        addFilter(new ItemStack(Blocks.field_150411_aY), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/iron_bars.png")));
        addFilter(new ItemStack(Blocks.field_150468_ap), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/ladder.png")));
        addFilter(new ItemStack(Blocks.field_150415_aT), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/trapdoor.png")));
        addFilter(new ItemStack(Blocks.field_180400_cw), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/iron_trapdoor.png")));
    }

    public static void renderFill(ResourceLocation textureLocation, BlockPos pos, double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        renderFill(textureLocation, pos, x, y, z, minX, minY, minZ, maxX, maxY, maxZ, EnumFacing.field_82609_l);
    }

    public static void renderFill(ResourceLocation textureLocation, BlockPos pos, double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, EnumFacing[] facing) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder renderer = t.func_178180_c();
        renderer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_176600_a);
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);

        preRender(x, y, z);

        TextureAtlasSprite sprite = minecraft.func_147117_R().getTextureExtry(textureLocation.toString());
        for (EnumFacing f : facing)
            drawTexturedQuad(renderer, sprite, minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ, pos, f);

        t.func_78381_a();
        postRender();
    }

    /*
    Everything from this point onward was shamelessly taken from Tinkers Construct. I'm sorry, but at some point, models are just too limited.
     */
    public static void preRender(double x, double y, double z) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel(GL11.GL_SMOOTH);
        } else
            GL11.glShadeModel(GL11.GL_FLAT);
        GlStateManager.func_179137_b(x, y, z);
    }

    public static void postRender() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public static void drawTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, BlockPos pos, EnumFacing facing) {
        if (sprite == null) {
            sprite = minecraft.func_147117_R().func_174944_f();
        }
        int brightness = minecraft.field_71441_e.func_175626_b(pos.func_177972_a(facing), minecraft.field_71441_e.func_175699_k(pos));
        int light1 = brightness >> 0x10 & 0xFFFF;
        int light2 = brightness & 0xFFFF;

        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        double minU;
        double maxU;
        double minV;
        double maxV;

        double size = 16F;

        double x2 = x + w;
        double y2 = y + h;
        double z2 = z + d;

        double xt1 = x % 1D;
        double xt2 = xt1 + w;
        while (xt2 > 1D) xt2 -= 1D;
        double yt1 = y % 1D;
        double yt2 = yt1 + h;
        while (yt2 > 1D) yt2 -= 1D;
        double zt1 = z % 1D;
        double zt2 = zt1 + d;
        while (zt2 > 1D) zt2 -= 1D;

        switch (facing) {
            case DOWN:
            case UP:
                minU = sprite.func_94214_a(xt1 * size);
                maxU = sprite.func_94214_a(xt2 * size);
                minV = sprite.func_94207_b(zt1 * size);
                maxV = sprite.func_94207_b(zt2 * size);
                break;
            case NORTH:
            case SOUTH:
                minU = sprite.func_94214_a(xt2 * size);
                maxU = sprite.func_94214_a(xt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            case WEST:
            case EAST:
                minU = sprite.func_94214_a(zt2 * size);
                maxU = sprite.func_94214_a(zt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            default:
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
        }

        switch (facing) {
            case DOWN:
                renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            case UP:
                renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            case NORTH:
                renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            case SOUTH:
                renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            case WEST:
                renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            case EAST:
                renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
        }
    }

    public static TextureAtlasSprite getSprite(ItemStack stack) {
        if (stack == null || stack.func_190926_b())
            return textureGetter.apply(TextureMap.field_174945_f);
        if (renderItem == null) {
            renderItem = Minecraft.func_71410_x().func_175599_af();
        }
        return renderItem.func_184393_a(stack, null, null).func_177554_e();
    }

    public static ResourceLocation getResourceLocation(ItemStack stack) {
        TextureAtlasSprite sprite = getSprite(stack);
        String iconLoc = sprite.func_94215_i();
        String split[] = ResourceLocation.func_177516_a(iconLoc);
        return new ResourceLocation(split[0], "textures/" + split[1] + ".png");
    }

    public static int multiplyColor(int src, int dst) {
        int out = 0;
        for (int i = 0; i < 32; i += 8) {
            out |= ((((src >> i) & 0xFF) * ((dst >> i) & 0xFF) / 0xFF) & 0xFF) << i;
        }
        return out;
    }

    public static BakedQuad recolorQuad(BakedQuad quad, int color) {
        int c = DefaultVertexFormats.field_176600_a.func_177340_e() / 4;
        int v = DefaultVertexFormats.field_176600_a.func_181719_f() / 4;
        int[] vertexData = quad.func_178209_a();
        for (int i = 0; i < 4; i++) {
            vertexData[v * i + c] = RenderUtils.multiplyColor(vertexData[v * i + c], color);
        }
        return quad;
    }

    public static BufferedImage getTextureImage(ResourceLocation location) {
        try {
            ResourceLocation pngLocation = new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", "textures", location.func_110623_a(), ".png"));
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(pngLocation);
            return TextureUtil.func_177053_a(resource.func_110527_b());
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isModelValid(IBakedModel model) {
        return model != Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
    }

    public static TextureAtlasSprite getParticleTexture(IBlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        return model.func_177554_e();
    }

    public static TextureAtlasSprite getTextureFromFace(IBlockState state, EnumFacing facing) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (isModelValid(model)) {
            return model.func_188616_a(state, facing, 0).stream().findFirst().map(BakedQuad::func_187508_a)
                    .orElse(Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state));
        }
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }


    public static IModel getModel(ResourceLocation location) {
        try {
            return ModelLoaderRegistry.getModel(location);
        } catch (Exception e) {
            return null;
        }
    }

    public static void renderBoundingBox(Vec3d pos, Vec3d color, AxisAlignedBB... boxes) {
        GlStateManager.func_179132_a(false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();

        for (AxisAlignedBB box : boxes) {
            box = box.func_191194_a(pos);
            RenderGlobal.func_189694_a(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, (float) color.field_72450_a, (float) color.field_72448_b, (float) color.field_72449_c, 1.0F);
        }

        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a(true);
    }

    public static void renderDebugBoundingBox(double x, double y, double z, AxisAlignedBB... boxes) {
        if (!Minecraft.func_71410_x().func_175598_ae().func_178634_b())
            return;
        renderBoundingBox(new Vec3d(x, y, z), new Vec3d(0.5D, 0.5D, 1.0D), boxes);
    }

}

