package betterwithmods.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ModelLongBoi extends ModelBase
{
    /** main box for the wolf head */
    public ModelRenderer wolfHeadMain;
    /** The wolf's body */
    public ModelRenderer wolfBody;
    /** Wolf'se first leg */
    public ModelRenderer wolfLeg1;
    /** Wolf's second leg */
    public ModelRenderer wolfLeg2;
    /** Wolf's third leg */
    public ModelRenderer wolfLeg3;
    /** Wolf's fourth leg */
    public ModelRenderer wolfLeg4;
    /** The wolf's tail */
    ModelRenderer wolfTail;
    /** The wolf's mane */
    ModelRenderer wolfMane;

    public ModelLongBoi()
    {
        float f = 0.0F;
        float f1 = 13.5F;
        this.wolfHeadMain = new ModelRenderer(this, 0, 0);
        this.wolfHeadMain.func_78790_a(-2.0F, -3.0F, -2.0F, 6, 6, 4, 0.0F);
        this.wolfHeadMain.func_78793_a(-1.0F, 13.5F, -7.0F);
        this.wolfBody = new ModelRenderer(this, 18, 14);
        this.wolfBody.func_78790_a(-3.0F, -2.0F, -3.0F, 6, 9, 6, 0.0F);
        this.wolfBody.func_78793_a(0.0F, 14.0F, 2.0F);
        this.wolfMane = new ModelRenderer(this, 21, 0);
        this.wolfMane.func_78790_a(-3.0F, -3.0F, -3.0F, 8, 6, 7, 0.0F);
        this.wolfMane.func_78793_a(-1.0F, 14.0F, 2.0F);
        this.wolfLeg1 = new ModelRenderer(this, 0, 18);
        this.wolfLeg1.func_78790_a(0.0F, 0.0F, -1.0F, 2, 8, 2, 0.0F);
        this.wolfLeg1.func_78793_a(-2.5F, 16.0F, 7.0F);
        this.wolfLeg2 = new ModelRenderer(this, 0, 18);
        this.wolfLeg2.func_78790_a(0.0F, 0.0F, -1.0F, 2, 8, 2, 0.0F);
        this.wolfLeg2.func_78793_a(0.5F, 16.0F, 7.0F);
        this.wolfLeg3 = new ModelRenderer(this, 0, 18);
        this.wolfLeg3.func_78790_a(0.0F, 0.0F, -1.0F, 2, 8, 2, 0.0F);
        this.wolfLeg3.func_78793_a(-2.5F, 16.0F, -4.0F);
        this.wolfLeg4 = new ModelRenderer(this, 0, 18);
        this.wolfLeg4.func_78790_a(0.0F, 0.0F, -1.0F, 2, 8, 2, 0.0F);
        this.wolfLeg4.func_78793_a(0.5F, 16.0F, -4.0F);
        this.wolfTail = new ModelRenderer(this, 9, 18);
        this.wolfTail.func_78790_a(0.0F, 0.0F, -1.0F, 2, 8, 2, 0.0F);
        this.wolfTail.func_78793_a(-1.0F, 12.0F, 8.0F);
        this.wolfHeadMain.func_78784_a(16, 14).func_78790_a(-2.0F, -5.0F, 0.0F, 2, 2, 1, 0.0F);
        this.wolfHeadMain.func_78784_a(16, 14).func_78790_a(2.0F, -5.0F, 0.0F, 2, 2, 1, 0.0F);
        this.wolfHeadMain.func_78784_a(47, 22).func_78790_a(-0.5f, 0, -9, 3, 3, 7, 0.0F);
    }

    /**
     * Sets the models various rotation angles then renders the model.
     */
    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale)
    {
        super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);

        if (this.field_78091_s)
        {
            float f = 2.0F;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b(0.0F, 5.0F * scale, 2.0F * scale);
            this.wolfHeadMain.func_78791_b(scale);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a(0.5F, 0.5F, 0.5F);
            GlStateManager.func_179109_b(0.0F, 24.0F * scale, 0.0F);
            this.wolfBody.func_78785_a(scale);
            this.wolfLeg1.func_78785_a(scale);
            this.wolfLeg2.func_78785_a(scale);
            this.wolfLeg3.func_78785_a(scale);
            this.wolfLeg4.func_78785_a(scale);
            this.wolfTail.func_78791_b(scale);
            this.wolfMane.func_78785_a(scale);
            GlStateManager.func_179121_F();
        }
        else
        {
            this.wolfHeadMain.func_78791_b(scale);
            this.wolfBody.func_78785_a(scale);
            this.wolfLeg1.func_78785_a(scale);
            this.wolfLeg2.func_78785_a(scale);
            this.wolfLeg3.func_78785_a(scale);
            this.wolfLeg4.func_78785_a(scale);
            this.wolfTail.func_78791_b(scale);
            this.wolfMane.func_78785_a(scale);
        }
    }

    /**
     * Used for easily adding entity-dependent animations. The second and third float params here are the same second
     * and third as in the setRotationAngles method.
     */
    public void func_78086_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime)
    {
        EntityWolf entitywolf = (EntityWolf)entitylivingbaseIn;

        if (entitywolf.func_70919_bu())
        {
            this.wolfTail.field_78796_g = 0.0F;
        }
        else
        {
            this.wolfTail.field_78796_g = MathHelper.func_76134_b(limbSwing * 0.6662F) * 1.4F * limbSwingAmount;
        }

        if (entitywolf.func_70906_o())
        {
            this.wolfMane.func_78793_a(-1.0F, 16.0F, -3.0F);
            this.wolfMane.field_78795_f = ((float)Math.PI * 2F / 5F);
            this.wolfMane.field_78796_g = 0.0F;
            this.wolfBody.func_78793_a(0.0F, 18.0F, 0.0F);
            this.wolfBody.field_78795_f = ((float)Math.PI / 4F);
            this.wolfTail.func_78793_a(-1.0F, 21.0F, 6.0F);
            this.wolfLeg1.func_78793_a(-2.5F, 22.0F, 2.0F);
            this.wolfLeg1.field_78795_f = ((float)Math.PI * 3F / 2F);
            this.wolfLeg2.func_78793_a(0.5F, 22.0F, 2.0F);
            this.wolfLeg2.field_78795_f = ((float)Math.PI * 3F / 2F);
            this.wolfLeg3.field_78795_f = 5.811947F;
            this.wolfLeg3.func_78793_a(-2.49F, 17.0F, -4.0F);
            this.wolfLeg4.field_78795_f = 5.811947F;
            this.wolfLeg4.func_78793_a(0.51F, 17.0F, -4.0F);
        }
        else
        {
            this.wolfBody.func_78793_a(0.0F, 14.0F, 2.0F);
            this.wolfBody.field_78795_f = ((float)Math.PI / 2F);
            this.wolfMane.func_78793_a(-1.0F, 14.0F, -3.0F);
            this.wolfMane.field_78795_f = this.wolfBody.field_78795_f;
            this.wolfTail.func_78793_a(-1.0F, 12.0F, 8.0F);
            this.wolfLeg1.func_78793_a(-2.5F, 16.0F, 7.0F);
            this.wolfLeg2.func_78793_a(0.5F, 16.0F, 7.0F);
            this.wolfLeg3.func_78793_a(-2.5F, 16.0F, -4.0F);
            this.wolfLeg4.func_78793_a(0.5F, 16.0F, -4.0F);
            this.wolfLeg1.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F) * 1.4F * limbSwingAmount;
            this.wolfLeg2.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F + (float)Math.PI) * 1.4F * limbSwingAmount;
            this.wolfLeg3.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F + (float)Math.PI) * 1.4F * limbSwingAmount;
            this.wolfLeg4.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F) * 1.4F * limbSwingAmount;
        }

        this.wolfHeadMain.field_78808_h = entitywolf.func_70917_k(partialTickTime) + entitywolf.func_70923_f(partialTickTime, 0.0F);
        this.wolfMane.field_78808_h = entitywolf.func_70923_f(partialTickTime, -0.08F);
        this.wolfBody.field_78808_h = entitywolf.func_70923_f(partialTickTime, -0.16F);
        this.wolfTail.field_78808_h = entitywolf.func_70923_f(partialTickTime, -0.2F);
    }

    /**
     * Sets the model's various rotation angles. For bipeds, par1 and par2 are used for animating the movement of arms
     * and legs, where par1 represents the time(so that arms and legs swing back and forth) and par2 represents how
     * "far" arms and legs can swing at most.
     */
    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn)
    {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        this.wolfHeadMain.field_78795_f = headPitch * 0.017453292F;
        this.wolfHeadMain.field_78796_g = netHeadYaw * 0.017453292F;
        this.wolfTail.field_78795_f = ageInTicks;
    }
}
