package betterwithmods.client.gui;

import betterwithmods.BWMod;
import betterwithmods.client.container.other.ContainerInfernalEnchanter;
import betterwithmods.common.blocks.tile.TileEntityInfernalEnchanter;
import com.google.common.collect.Maps;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.ResourceLocation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by primetoxinz on 9/11/16.
 */
public class GuiInfernalEnchanter extends GuiBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation(BWMod.MODID, "textures/gui/infernal_enchanter.png");
    private static HashMap<Integer, String> numerals = Maps.newHashMap();

    static {
        numerals.put(22, "I");
        numerals.put(41, "II");
        numerals.put(60, "III");
        numerals.put(79, "IV");
        numerals.put(98, "V");
    }

    private FontRenderer fontGalactic;
    private TileEntityInfernalEnchanter tile;
    private ContainerInfernalEnchanter container;
    private EntityPlayer player;

    public GuiInfernalEnchanter(EntityPlayer player, TileEntityInfernalEnchanter tile) {
        super(new ContainerInfernalEnchanter(player, tile), TEXTURE);
        this.container = (ContainerInfernalEnchanter) field_147002_h;
        this.player = player;
        this.tile = tile;
        field_147000_g = 211;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (fontGalactic == null)
            fontGalactic = this.field_146297_k.field_71464_q;
    }

    @Override
    protected void drawExtras(float partialTicks, int mouseX, int mouseY, int centerX, int centerY) {
        if (!field_147002_h.func_75139_a(0).func_75216_d())
            func_73729_b(centerX + 17, centerY + 37, 176, 0, 16, 16);
        if (!field_147002_h.func_75139_a(1).func_75216_d())
            func_73729_b(centerX + 17, centerY + 75, 192, 0, 16, 16);
        EnchantmentNameParts.func_178176_a().func_148335_a((long) this.container.xpSeed);

        int x, y;
        for (int levelIndex = 0; levelIndex < container.enchantLevels.length; levelIndex++) {
            this.field_146297_k.field_71446_o.func_110577_a(background);
            GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);

            int level = container.enchantLevels[levelIndex];
            if (level > 0) {
                String levelString = String.valueOf(level);
                if (container.hasLevels(player, levelIndex) && container.hasBooks(levelIndex)) {
                    y = centerY + 17 + (19 * levelIndex);
                    x = centerX + 60;
                    if (mouseX >= x && mouseX <= x + 108 && mouseY >= y && mouseY <= y + 19) {
                        func_73729_b(x, y, 108, 211, 108, 19);
                    } else {
                        func_73729_b(x, y, 0, 211, 108, 19);
                    }
                }
                String galacticText = EnchantmentNameParts.func_178176_a().func_148334_a(this.field_146289_q, 86 - this.field_146289_q.func_78256_a(levelString));
                fontGalactic.func_78279_b(galacticText, centerX + 62, centerY + 19 + 19 * levelIndex, 108, 0x342f25);
                field_146289_q.func_175063_a(levelString, centerX + field_146999_f - 10 - this.field_146289_q.func_78256_a(levelString), centerY + 8 + 19 * (levelIndex + 1), 0x80FF20);
            }
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (Map.Entry<Integer, String> e : numerals.entrySet()) {
            this.field_146289_q.func_78276_b(e.getValue(), 50 - this.field_146289_q.func_78256_a(e.getValue()) / 2, e.getKey(), 0x404040);
        }
    }

    @Override
    public String getTitle() {
        return tile.getName();
    }

    @Override
    public int getTitleY() {
        return 6;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;

        int x, y;
        for (int levelIndex = 0; levelIndex < container.enchantLevels.length; levelIndex++) {
            if (container.enchantLevels[levelIndex] != -1 && container.hasLevels(player, levelIndex) && container.hasBooks(levelIndex)) {
                y = yPos + 17 + (19 * levelIndex);
                x = xPos + 60;
                if (mouseX >= x && mouseX <= x + 108 && mouseY >= y && mouseY <= y + 19) {
                    if (container.func_75140_a(player, levelIndex)) {
                        this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, levelIndex);
                    }
                }
            }
        }
    }
}

