package betterwithmods.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase extends GuiContainer {
    protected ResourceLocation background;

    public GuiBase(Container inventorySlotsIn, ResourceLocation background) {
        super(inventorySlotsIn);
        this.background = background;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.field_146297_k.field_71446_o.func_110577_a(background);

        int centerX = (this.field_146294_l - this.field_146999_f) / 2;
        int centerY = (this.field_146295_m - this.field_147000_g) / 2;
        func_73729_b(centerX, centerY, 0, 0, this.field_146999_f, this.field_147000_g);
        drawExtras(partialTicks,mouseX,mouseY,centerX,centerY);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        String s = I18n.func_135052_a(getTitle());
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, getTitleY(), getTitleColor());
    }

    public abstract String getTitle();
    public abstract int getTitleY();
    public int getTitleColor() {
        return 4210752;
    }


    protected void drawExtras(float partialTicks, int mouseX, int mouseY, int centerX, int centerY) {}
}
