package betterwithmods.client.container.other;

import betterwithmods.client.container.ContainerProgress;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerPulley extends ContainerProgress {
    private final TileEntityPulley tile;

    public ContainerPulley(EntityPlayer player, TileEntityPulley tile) {
        super(tile);
        this.tile = tile;

        for (int i = 0; i < 4; i++) {
            func_75146_a(new SlotItemHandler(tile.inventory, i, 53 + i * 18, 52) {
                @Override
                public boolean func_75214_a(ItemStack stack) {
                    return super.func_75214_a(stack) && stack.func_77973_b() == Item.func_150898_a(BWMBlocks.ROPE);
                }
            });
        }

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                func_75146_a(
                        new SlotItemHandler(player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null),
                                j + i * 9 + 9, 8 + j * 18, 93 + i * 18));
            }
        }

        for (int i = 0; i < 9; i++) {
            func_75146_a(new SlotItemHandler(
                    player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), i, 8 + i * 18, 151));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return tile.isUseableByPlayer(player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack clickedStack = ItemStack.field_190927_a;
        Slot slot = this.field_75151_b.get(index);

        if (slot != null && slot.func_75216_d()) {
            ItemStack processedStack = slot.func_75211_c();
            clickedStack = processedStack.func_77946_l();

            if (index < 4) {
                if (!func_75135_a(processedStack, 4, this.field_75151_b.size(), true))
                    return ItemStack.field_190927_a;
            } else if (!func_75135_a(processedStack, 0, 3, false)) {
                return ItemStack.field_190927_a;
            }

            if (processedStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return clickedStack;
    }
}
