package betterwithmods.client.container.other;

import betterwithmods.common.blocks.tile.FilteredStackHandler;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityInfernalEnchanter;
import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.util.InfernalEnchantment;
import betterwithmods.util.InvUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

import java.util.Arrays;
import java.util.Set;

/**
 * Created by primetoxinz on 9/11/16.
 */
public class ContainerInfernalEnchanter extends Container {
    public static final int INV_LAST = 1;
    public int[] enchantLevels;
    public int xpSeed;
    public int bookcaseCount;
    private TileEntityInfernalEnchanter tile;
    private SimpleStackHandler handler;


    public ContainerInfernalEnchanter(EntityPlayer player, TileEntityInfernalEnchanter tile) {
        this.tile = tile;
        this.enchantLevels = new int[5];
        this.bookcaseCount = tile.getBookcaseCount();
        handler = new FilteredStackHandler(2, tile, stack -> stack.func_77973_b() instanceof ItemArcaneScroll, stack -> true) {
            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                onContextChanged(this);
            }
        };
        this.xpSeed = player.func_175138_ci();
        IItemHandler playerInv = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        func_75146_a(new SlotItemHandler(handler, 0, 17, 37));
        func_75146_a(new SlotItemHandler(handler, 1, 17, 75));
        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                func_75146_a(new SlotItemHandler(playerInv, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (int i = 0; i < 9; i++) {
            func_75146_a(new SlotItemHandler(playerInv, i, 8 + i * 18, 187));
        }
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            default:
                if (id < this.enchantLevels.length) {
                    enchantLevels[id] = data;
                }
                break;
            case 3:
                xpSeed = data;
                break;
            case 4:
                bookcaseCount = data;
                break;
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            this.broadcastData(listener);
        }
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        broadcastData(listener);
    }

    public void broadcastData(IContainerListener listener) {
        for (int i = 0; i < this.enchantLevels.length; i++) {
            listener.func_71112_a(this, i, this.enchantLevels[i]);
        }
        listener.func_71112_a(this, 3, this.xpSeed & -16);
        listener.func_71112_a(this, 4, this.tile.getBookcaseCount());
    }

    public boolean areValidItems(ItemStack scroll, ItemStack item) {
        if (!scroll.func_190926_b() && !item.func_190926_b()) {
            Enchantment enchantment = new InfernalEnchantment(ItemArcaneScroll.getEnchantment(scroll));
            if (enchantment == null)
                return false;
            Set<Enchantment> enchantments = EnchantmentHelper.func_82781_a(item).keySet();
            if (enchantments.contains(enchantment))
                return false;
            for (Enchantment e : enchantments) {
                if (!e.func_191560_c(enchantment))
                    return false;
            }

            if (item.func_77973_b().canApplyAtEnchantingTable(item, enchantment)) {
                return true;
            }
        }
        return false;
    }

    public void onContextChanged(IItemHandler handler) {
        ItemStack scroll = handler.getStackInSlot(0);
        ItemStack item = handler.getStackInSlot(1);
        if (areValidItems(scroll, item)) {
            Enchantment enchantment = ItemArcaneScroll.getEnchantment(scroll);
            int enchantCount = EnchantmentHelper.func_82781_a(item).size();
            for (int levelIndex = 1; levelIndex <= enchantLevels.length; levelIndex++) {
                enchantLevels[levelIndex - 1] = getEnchantCost(levelIndex, enchantment, enchantCount);
            }
        } else {
            Arrays.fill(enchantLevels, -1);
        }
        func_75142_b();
    }

    private int getEnchantCost(int levelIndex, Enchantment enchantment, int enchantCount) {
        if (enchantment == null || levelIndex > enchantment.func_77325_b()) {
            return -1;
        } else {
            double max = Math.min(enchantment.func_77325_b(), enchantLevels.length);
            double multiplier = levelIndex / max;
            return (int) Math.ceil(30.0 * multiplier) + (30 * enchantCount);
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = this.field_75151_b.get(index);

        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index > INV_LAST) {
                if (itemstack1.func_77973_b() instanceof ItemArcaneScroll) {
                    if (!func_75135_a(itemstack1, 0, 1, true))
                        return ItemStack.field_190927_a;
                } else {
                    if (!func_75135_a(itemstack1, 1, 2, true))
                        return ItemStack.field_190927_a;
                }
            } else {
                if (!func_75135_a(itemstack1, 2, 37, true))
                    return ItemStack.field_190927_a;
            }

            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }

            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }

            slot.func_190901_a(player, itemstack1);
        }
        handler.onContentsChanged(index);
        return itemstack;
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @Override
    public void func_75134_a(EntityPlayer playerIn) {
        for (int i = 0; i < handler.getSlots(); i++) {
            ItemStack stack = handler.getStackInSlot(i);

            if (!stack.func_190926_b() && !playerIn.func_130014_f_().field_72995_K)
                InvUtils.ejectStack(playerIn.func_130014_f_(), playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, stack);
        }
    }


    public boolean hasLevels(EntityPlayer player, int levelIndex) {
        return player.field_71075_bZ.field_75098_d || player.field_71068_ca >= this.enchantLevels[levelIndex];
    }

    public boolean hasBooks(int levelIndex) {
        return tile.getBookcaseCount() >= this.enchantLevels[levelIndex];
    }

    @Override
    public boolean func_75140_a(EntityPlayer player, int levelIndex) {
        if (hasLevels(player, levelIndex) && hasBooks(levelIndex)) {
            if (!player.field_70170_p.field_72995_K) {
                ItemStack item = this.handler.getStackInSlot(1);
                ItemStack scroll = this.handler.getStackInSlot(0);
                Enchantment enchantment = ItemArcaneScroll.getEnchantment(scroll);
                if (enchantment != null) {
                    scroll.func_190918_g(1);
                    item.func_77966_a(enchantment, levelIndex + 1);
                    player.func_192024_a(item, this.enchantLevels[levelIndex]);
                    tile.func_145831_w().func_184133_a(null, tile.func_174877_v(), SoundEvents.field_187754_de, SoundCategory.BLOCKS, 1.0F, tile.func_145831_w().field_73012_v.nextFloat() * 0.1F + 0.9F);
                    onContextChanged(this.handler);
                }
            }
            return true;
        }
        return false;
    }
}
