package betterwithmods.client.container.other;

import betterwithmods.common.blocks.tile.TileEntityBlockDispenser;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerBlockDispenser extends Container {
    private final TileEntityBlockDispenser tile;
    private int nextSlot;

    public ContainerBlockDispenser(EntityPlayer player, TileEntityBlockDispenser tile) {
        this.tile = tile;
        IItemHandler playerInv = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < 4; i++) {
            for (int j = 0; j < 4; j++) {
                func_75146_a(new SlotItemHandler(tile.inventory, j + i * 4, 53 + j * 18, 17 + i * 18));
            }
        }

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                func_75146_a(new SlotItemHandler(playerInv, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }

        for (int i = 0; i < 9; i++) {
            func_75146_a(new SlotItemHandler(playerInv, i, 8 + i * 18, 160));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return tile.isUseableByPlayer(player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = this.field_75151_b.get(slotIndex);

        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();

            if (slotIndex < 16) {
                if (!func_75135_a(stack1, 16, this.field_75151_b.size(), true))
                    return ItemStack.field_190927_a;
            } else if (!func_75135_a(stack1, 0, 16, false))
                return ItemStack.field_190927_a;

            if (stack1.func_190916_E() == 0)
                slot.func_75215_d(ItemStack.field_190927_a);
            else
                slot.func_75218_e();
        }
        return stack;
    }

    @Override
    public ItemStack func_184996_a(int x, int dragType, ClickType type, EntityPlayer player) {
        if (x < 16)
            this.tile.nextIndex = 0;

        return super.func_184996_a(x, dragType, type, player);
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a(this, 0, this.tile.nextIndex);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();

        for (IContainerListener craft : this.field_75149_d) {
            if (this.nextSlot != this.tile.nextIndex)
                craft.func_71112_a(this, 0, this.tile.nextIndex);
        }

        this.nextSlot = this.tile.nextIndex;
    }

    @Override
    public void func_75137_b(int index, int value) {
        if (index == 0) {
            this.tile.nextIndex = value;
        }
    }

}
