package betterwithmods.client.container.inventory;

import betterwithmods.client.container.anvil.InventorySteelCrafting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

import javax.annotation.Nullable;

public class SlotCraftingItemHandler extends Slot {
    private final InventorySteelCrafting craftingInv;
    private final IItemHandler matrix;
    private final EntityPlayer player;

    public SlotCraftingItemHandler(EntityPlayer player, InventoryCrafting craftingInventory, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
        super(inventoryIn, slotIndex, xPosition, yPosition);
        craftingInv = (InventorySteelCrafting) craftingInventory;
        this.player = player;
        this.matrix = ((InventorySteelCrafting) craftingInventory).craft.inventory;
    }

    /**
     * Check if the stack is allowed to be placed in this slot, used for armor slots as well as furnace fuel.
     */
    public boolean func_75214_a(@Nullable ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < matrix.getSlots(); i++) {
            if (!matrix.getStackInSlot(i).func_190926_b()) {
                matrix.extractItem(i, 1, false);
            }
        }
        //craftingInv.craft.setResult(ExtremeCraftingManager.getInstance().findMatchingRecipe(craftingInv, craftingInv.craft.getBlockWorld()));
        craftingInv.container.func_75130_a(craftingInv);
        return stack;
    }
}
