package betterwithmods.client.container.bulk;

import betterwithmods.client.container.ContainerProgress;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCookingPot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerCookingPot extends ContainerProgress {
    private final TileEntityCookingPot tile;
    private int heat;

    public ContainerCookingPot(EntityPlayer player, TileEntityCookingPot tile) {
        super(tile);
        IItemHandler playerInv = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.tile = tile;

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                func_75146_a(new SlotItemHandler(tile.inventory, j + i * 9, 8 + j * 18, 43 + i * 18));
            }
        }

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                func_75146_a(new SlotItemHandler(playerInv, j + i * 9 + 9, 8 + j * 18, 111 + i * 18));
            }
        }

        for (int i = 0; i < 9; i++) {
            func_75146_a(new SlotItemHandler(playerInv, i, 8 + i * 18, 169));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.isUseableByPlayer(player);
    }

    @Override
    public ItemStack func_184996_a(int x, int dragType, ClickType type, EntityPlayer player) {
        this.tile.func_70296_d();
        return super.func_184996_a(x, dragType, type, player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = this.field_75151_b.get(slotIndex);

        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();

            if (slotIndex < 27) {
                if (!func_75135_a(stack1, 27, this.field_75151_b.size(), true))
                    return ItemStack.field_190927_a;
            } else if (!func_75135_a(stack1, 0, 27, false))
                return ItemStack.field_190927_a;

            if (stack1.func_190916_E() < 1)
                slot.func_75215_d(ItemStack.field_190927_a);
            else
                slot.func_75218_e();
        }
        return stack;
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a(this, 2, this.tile.getHeat(tile.func_145831_w(), tile.func_174877_v()));
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        int h = this.tile.getHeat(tile.func_145831_w(), tile.func_174877_v());
        if (heat != h) {
            heat = h;
            for (IContainerListener craft : this.field_75149_d) {
                craft.func_71112_a(this, 2, heat);
            }
        }
    }

    @Override
    public void func_75137_b(int index, int value) {
        super.func_75137_b(index, value);
        switch (index) {
            case 2:
                heat = value;
                break;
        }
    }

    public int getHeat() {
        return heat;
    }
}
