package betterwithmods.client.container.anvil;

import betterwithmods.common.blocks.tile.TileEntitySteelAnvil;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InventorySteelCrafting extends InventoryCrafting {

    public TileEntitySteelAnvil craft;
    public Container container;
    private IItemHandler handler;

    public InventorySteelCrafting(Container container, TileEntitySteelAnvil te) {
        super(container, 4, 4);
        craft = te;
        handler = te.inventory;
        this.container = container;
    }


    @Override
    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? null : handler.getStackInSlot(slot);
    }

    @Override
    public ItemStack func_70463_b(int row, int column) {
        if (row >= 0 && row < 4) {
            int x = row + column * 4;
            return this.func_70301_a(x);
        } else {
            return null;
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int decrement) {
        ItemStack stack = handler.getStackInSlot(slot);
        this.container.func_75130_a(this);
        if (stack != null) {
            ItemStack itemstack;
            if (stack.func_190916_E() <= decrement) {
                itemstack = stack.func_77946_l();
                stack = ItemStack.field_190927_a;
                craft.setInventorySlotContents(slot, ItemStack.field_190927_a);
                this.container.func_75130_a(this);
                return itemstack;
            } else {
                itemstack = stack.func_77979_a(decrement);
                if (stack.func_190916_E() == 0) {
                    stack = ItemStack.field_190927_a;
                    craft.setInventorySlotContents(slot, ItemStack.field_190927_a);
                }
                this.container.func_75130_a(this);
                return itemstack;
            }
        } else {
            return null;
        }
    }

    public void craft() {
        for (int i = 0; i < handler.getSlots(); i++) {
            if (!handler.getStackInSlot(i).func_190926_b()) {
                handler.extractItem(i, 1, false);
            }
        }
        this.container.func_75130_a(this);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        craft.setInventorySlotContents(slot, itemstack);
        this.container.func_75130_a(this);
    }

}
