package betterwithmods.client.container.anvil;

import betterwithmods.common.blocks.tile.TileEntitySteelAnvil;
import betterwithmods.common.registry.anvil.AnvilCraftingManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerSteelAnvil extends Container {
    private final int INV_FIRST = 17;
    private final int INV_LAST = 44;
    private final int HOT_LAST = 53;
    public InventoryCrafting craftMatrix;
    public IInventory craftResult;
    public InventoryPlayer inventoryPlayer;

    public EntityPlayer player;
    private TileEntitySteelAnvil te;
    private IItemHandler handler;

    public ContainerSteelAnvil(InventoryPlayer inventory, TileEntitySteelAnvil te) {
        this.te = te;
        this.handler = te.inventory;
        this.inventoryPlayer = inventory;
        this.player = inventory.field_70458_d;
        craftMatrix = new InventorySteelCrafting(this, te);
        craftResult = new InventorySteelCraftingResult(te);
        this.func_75146_a(new SlotSteelAnvilCrafting(player, craftMatrix, craftResult, 0, 124, 44));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.func_75146_a(new Slot(craftMatrix, j + i * 4, 12 + j * 18, 17 + i * 18));
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(inventory, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(inventory, i, 8 + i * 18, 160));
        }
        this.func_75130_a(craftMatrix);
    }

    /**
     * Callback for when the crafting matrix is changed.
     */
    public void func_75130_a(IInventory matrix) {

        this.craftResult.func_70299_a(0, AnvilCraftingManager.findMatchingResult(this.craftMatrix, te.func_145831_w()));
    }

    /**
     * Called when the container is closed.
     */
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);

    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return te.isUseableByPlayer(player);
    }

    /**
     * Called when a player shift-clicks on a slot. You must override this or you will crash when someone does that.
     */

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = this.field_75151_b.get(index);

        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();

            if (index == 0) {
                if (!this.func_75135_a(itemstack1, INV_FIRST, HOT_LAST, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= INV_FIRST && index < INV_LAST) {
                if (!this.func_75135_a(itemstack1, INV_LAST, HOT_LAST, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= INV_LAST && index < HOT_LAST) {
                if (!this.func_75135_a(itemstack1, INV_FIRST, INV_LAST, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(itemstack1, INV_FIRST, HOT_LAST, false)) {
                return ItemStack.field_190927_a;
            }

            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }

            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }

            slot.func_190901_a(player, itemstack1);
        }

        return itemstack;
    }
}
