package betterwithmods.client.container;

import betterwithmods.api.util.IProgressSource;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;

public abstract class ContainerProgress extends Container {
    private IProgressSource progressSource;

    private int previousProgress, previousMax;
    private int progress, max;

    public ContainerProgress(IProgressSource progressSource) {
        this.progressSource = progressSource;
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);

        listener.func_71112_a(this, 0, progressSource.getMax());
        listener.func_71112_a(this, 1, progressSource.getProgress());
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();

        this.progress = progressSource.getProgress();
        this.max = progressSource.getMax();

        for (IContainerListener craft : this.field_75149_d) {

            if (this.previousMax != this.max)
                craft.func_71112_a(this, 0, this.max);
            if (this.previousProgress != progress)
                craft.func_71112_a(this, 1, progress);

        }

        this.previousProgress = this.progress;
        this.previousMax = this.max;
    }

    @Override
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0:
                this.max = data;
            case 1:
                this.progress = data;
        }
    }

    public int getProgress() {
        return progress;
    }

    public int getMax() {
        return max;
    }

    public boolean showProgress() {
        return progress > 0 && max > 0;
    }

}
