package betterwithmods.client;

import betterwithmods.common.blocks.BlockPlanter;
import betterwithmods.common.blocks.ItemBlockPlanter;
import betterwithmods.common.items.tools.BWMArmor;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.biome.BiomeColorHelper;

/**
 * Created by Christian on 21.10.2016.
 */
public class ColorHandlers {
    public static final IBlockColor BlockPlanterColor = (state, worldIn, pos, tintIndex) ->
            state.func_177230_c() instanceof BlockPlanter ? ((BlockPlanter) state.func_177230_c()).colorMultiplier(state, worldIn, pos, tintIndex) : -1;
    public static final IBlockColor BlockFoliageColor = (state, worldIn, pos, tintIndex) ->
            worldIn != null && pos != null ? BiomeColorHelper.func_180287_b(worldIn, pos) : ColorizerFoliage.func_77470_a(0.5D, 1.0D);
    public static final IBlockColor BlockBloodLeafColor = (state, worldIn, pos, tintIndex) ->
            worldIn != null && pos != null ? blendColors(0xB70606, BiomeColorHelper.func_180287_b(worldIn, pos)) : blendColors(0xB70606, ColorizerFoliage.func_77470_a(0.5D, 1.0D));

    public static final IItemColor ItemPlanterColor = (stack, tintIndex) ->
            (stack.func_77973_b() instanceof ItemBlock && stack.func_77973_b() instanceof ItemBlockPlanter) ? ((ItemBlockPlanter) stack.func_77973_b()).getColorFromItemStack(stack, tintIndex) : -1;
    public static final IItemColor ItemFoliageColor = (stack, tintIndex) ->
            BlockFoliageColor.func_186720_a(((ItemBlock) stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, tintIndex);
    public static final IItemColor ItemBloodLeafColor = (stack, tintIndex) ->
            BlockBloodLeafColor.func_186720_a(((ItemBlock) stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, tintIndex);

    public static final IItemColor armor = (stack, tintIndex) ->
            (tintIndex != 1 && stack.func_77973_b() instanceof BWMArmor) ? ((BWMArmor) stack.func_77973_b()).func_82814_b(stack) : -1;

    public static int blendColors(int main, int blend) {
        float mRatio = 0.825F;
        float ratio = 0.175F;

        int mainA = main >> 24 & 0xFF;
        int mainR = (main & 0xFF0000) >> 16;
        int mainG = (main & 0xFF00) >> 8;
        int mainB = main & 0xFF;

        int blendA = blend >> 24 & 0xFF;
        int blendR = (blend & 0xFF0000) >> 16;
        int blendG = (blend & 0xFF00) >> 8;
        int blendB = blend & 0xFF;

        int a = (int) ((mainA * mRatio) + (blendA * ratio));
        int r = (int) ((mainR * mRatio) + (blendR * ratio));
        int g = (int) ((mainG * mRatio) + (blendG * ratio));
        int b = (int) ((mainB * mRatio) + (blendB * ratio));

        return a << 24 | r << 16 | g << 8 | b;
    }

}
