package betterwithmods.client;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import javax.annotation.Nullable;

/*
 * Copyright (c) 2015, 2016, 2017, 2018 Adrian Siekierka
 *
 * This file is part of Charset.
 *
 * Charset is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Charset is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Charset.  If not, see <http://www.gnu.org/licenses/>.
 */

public class BWParticleDigging extends ParticleDigging {
    private final IBlockState sourceState;
    private final int particleTintIndex;

    public BWParticleDigging(World worldIn, double xIn, double yIn, double zIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, IBlockState state, BlockPos pos, TextureAtlasSprite sprite, int particleTintIndex) {
        super(worldIn, xIn, yIn, zIn, xSpeedIn, ySpeedIn, zSpeedIn, state);
        this.sourceState = state;
        this.particleTintIndex = particleTintIndex;
        func_174846_a(pos);
        func_187117_a(sprite);
    }

    @Override
    protected void func_187154_b(@Nullable BlockPos p_187154_1_) {
        if (particleTintIndex >= 0) {
            int i = Minecraft.func_71410_x().func_184125_al().func_186724_a(this.sourceState, this.field_187122_b, p_187154_1_, particleTintIndex);
            if (i != -1) {
                this.field_70552_h *= (float) (i >> 16 & 255) / 255.0F;
                this.field_70553_i *= (float) (i >> 8 & 255) / 255.0F;
                this.field_70551_j *= (float) (i & 255) / 255.0F;
            }
        }
    }
}
