package betterwithmods.api.tile.dispenser;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * Created by primetoxinz on 5/25/17.
 */
@FunctionalInterface
public interface IBehaviorCollect {
    NonNullList<ItemStack> collect(IBlockSource source);

    default void breakBlock(World world, IBlockState state, BlockPos pos) {
        world.func_184133_a(null, pos, state.func_177230_c().getSoundType(state, world, pos, null).func_185841_e(), SoundCategory.BLOCKS, 0.7F, 1.0F);
        state.func_177230_c().func_180663_b(world, pos, state);
        world.func_175718_b(2001, pos, Block.func_149682_b(state.func_177230_c()));
        world.func_175698_g(pos);
    }
}
