package betterwithmods.api.tile;

import betterwithmods.api.block.IOverpower;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IMechanicalPower {
    int getMechanicalOutput(EnumFacing facing);

    int getMechanicalInput(EnumFacing facing);

    int getMaximumInput(EnumFacing facing);

    int getMinimumInput(EnumFacing facing);

    Block getBlock();

    World getBlockWorld();

    BlockPos getBlockPos();

    default int calculateInput() {
        int findPower = 0;
        boolean overpowered = false;
        for (EnumFacing facing : EnumFacing.values()) {
            int power = getMechanicalInput(facing);
            if (power > findPower)
                findPower = power;
            if (power > getMaximumInput(facing))
                overpowered = true;
        }
        if (overpowerChance() && overpowered) {
            overpower();
            return 0;
        }
        return findPower;
    }

    default boolean overpowerChance() {
        return getBlockWorld().field_73012_v.nextInt(10) == 0;
    }

    default void overpower() {
        if (getBlock() instanceof IOverpower)
            ((IOverpower) getBlock()).overpower(getBlockWorld(), getBlockPos());
    }

}
