package betterwithmods.api.block;

import betterwithmods.common.BWSounds;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * Created by primetoxinz on 7/18/17.
 */
public interface IOverpower {
    void overpower(World world, BlockPos pos);

    default void overpowerSound(World world, BlockPos pos) {
        for (int i = 0; i < 10; i++) {
            world.func_184133_a(null, pos, BWSounds.MECHANICAL_OVERPOWER, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1F + 0.45F);
        }
        for (int i = 0; i < 5; i++) {
            float flX = pos.func_177958_n() + world.field_73012_v.nextFloat();
            float flY = pos.func_177956_o() + world.field_73012_v.nextFloat() * 0.5F + 1.0F;
            float flZ = pos.func_177952_p() + world.field_73012_v.nextFloat();

            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, flX, flY, flZ, 0.0D, 0.0D, 0.0D);
        }
    }
}
