/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.player;

import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.BrokenToolRegistry;
import betterwithmods.module.hardcore.needs.HCArmor;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class PlayerHelper {
    public static final UUID PENALTY_SPEED_UUID = UUID.fromString("c5595a67-9410-4fb2-826a-bcaf432c6a6f");

    private PlayerHelper() {
    }

    public static ItemStack getHolding(EntityPlayer player, EnumHand hand) {
        if (hand != null) {
            return player.getHeldItem(hand);
        }
        return player.getHeldItem(EnumHand.MAIN_HAND);
    }

    public static Set<ItemStack> getHolding(EntityPlayer player) {
        return Sets.newHashSet((Object[])new ItemStack[]{player.getHeldItemMainhand(), player.getHeldItemOffhand()}).stream().filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public static boolean isHolding(EntityPlayer player, Ingredient ingredient) {
        Set<ItemStack> held = PlayerHelper.getHolding(player);
        if (held.isEmpty()) {
            return false;
        }
        for (ItemStack h : held) {
            if (!ingredient.apply(h)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSurvival(EntityPlayer player) {
        return player != null && !player.isCreative() && !player.isSpectator() && !player.isSpectator();
    }

    public static boolean isNearBottom(EntityPlayer player) {
        World world = player.getEntityWorld();
        BlockPos a = player.getPosition().down(1);
        BlockPos b = player.getPosition().down(2);
        return !world.getBlockState(a).getMaterial().isReplaceable() && !world.getBlockState(b).getMaterial().isReplaceable();
    }

    public static void changeAttack(EntityLivingBase entity, UUID attackModifierUUID, String name, double multiplier) {
        AttributeModifier attackModifier = new AttributeModifier(attackModifierUUID, name, multiplier - 1.0, 2);
        IAttributeInstance iattributeinstance = entity.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        if (iattributeinstance.getModifier(attackModifierUUID) != null) {
            iattributeinstance.removeModifier(attackModifier);
        }
        iattributeinstance.applyModifier(attackModifier);
    }

    public static void changeSpeed(EntityLivingBase entity, String name, double modifier, UUID penaltySpeedUuid) {
        AttributeModifier speedModifier = new AttributeModifier(penaltySpeedUuid, name, modifier - 1.0, 2);
        IAttributeInstance iattributeinstance = entity.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        if (iattributeinstance.getModifier(penaltySpeedUuid) != null) {
            iattributeinstance.removeModifier(speedModifier);
        }
        iattributeinstance.applyModifier(speedModifier);
    }

    public static int getWornArmorWeight(EntityPlayer player) {
        int weight = 0;
        for (ItemStack stack : player.inventory.armorInventory) {
            if (stack == null) continue;
            weight = (int)((float)weight + HCArmor.getWeight(stack));
        }
        return weight;
    }

    public static boolean isCurrentToolEffectiveOnBlock(EntityPlayer player, BlockPos pos, IBlockState state) {
        ItemStack stack = BrokenToolRegistry.findItem(player, state);
        if (player == null || state == null) {
            return false;
        }
        return PlayerHelper.isCurrentToolEffectiveOnBlock(stack, state, Sets.newHashSet()) || ForgeHooks.isToolEffective((IBlockAccess)player.getEntityWorld(), (BlockPos)pos, (ItemStack)stack);
    }

    public static boolean isCurrentToolEffectiveOnBlock(ItemStack stack, IBlockState state, Set<Material> effective_materials) {
        NBTTagCompound stats;
        if (stack == null) {
            return false;
        }
        if (stack.hasTagCompound() && (stats = stack.getSubCompound("Stats")) != null) {
            return stats.getByte("Broken") != 1;
        }
        ItemStack block = BWMRecipes.getStackFromState(state);
        Material material = state.getMaterial();
        if (effective_materials.contains(material)) {
            return true;
        }
        for (String type : stack.getItem().getToolClasses(stack)) {
            if (Objects.equals(type, "mattock")) {
                return state.getBlock().isToolEffective("shovel", state) || state.getBlock().isToolEffective("axe", state);
            }
            if (Objects.equals(type, "bwmmattock")) {
                return state.getBlock().isToolEffective("shovel", state) || state.getBlock().isToolEffective("pickaxe", state);
            }
            if (!state.getBlock().isToolEffective(type, state) && !BWOreDictionary.isToolForOre(type, block)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getPlayerHead(EntityPlayer player) {
        ItemStack head = new ItemStack(Items.SKULL, 1, 3);
        NBTTagCompound name = new NBTTagCompound();
        name.setString("SkullOwner", player.getDisplayNameString());
        head.setTagCompound(name);
        return head;
    }

    public static boolean hasFullSet(EntityPlayer player, Class<? extends ItemArmor> armor) {
        for (ItemStack stack : player.getArmorInventoryList()) {
            if (armor.isAssignableFrom(stack.getItem().getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPart(EntityLivingBase living, EntityEquipmentSlot type, Class<? extends ItemArmor> armor) {
        return armor.isAssignableFrom(living.getItemStackFromSlot(type).getItem().getClass());
    }

    public static UUID getUUID(EntityPlayer player) {
        GameProfile profile = player.getGameProfile();
        if (profile != null) {
            return profile.getId();
        }
        return player.getUniqueID();
    }

    public static boolean isMoving(EntityPlayer player) {
        return player.motionX != 0.0 && player.motionZ != 0.0;
    }
}

