/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.item;

import betterwithmods.util.ReflectionLib;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class ToolsManager {
    private ToolsManager() {
    }

    public static Item.ToolMaterial getToolMaterial(ItemStack tool) {
        Item item = tool.getItem();
        if (item instanceof ItemTool) {
            return Item.ToolMaterial.valueOf((String)((ItemTool)item).getToolMaterialName());
        }
        return null;
    }

    public static void setAxesAsEffectiveAgainst(Block ... blocks) {
        for (Item item : Item.REGISTRY) {
            if (!(item instanceof ItemAxe)) continue;
            ItemAxe tool = (ItemAxe)item;
            ToolsManager.setToolAsEffectiveAgainst((ItemTool)tool, blocks);
        }
    }

    public static void setPickaxesAsEffectiveAgainst(Block ... blocks) {
        for (Item item : Item.REGISTRY) {
            if (!(item instanceof ItemPickaxe)) continue;
            ItemPickaxe tool = (ItemPickaxe)item;
            ToolsManager.setToolAsEffectiveAgainst((ItemTool)tool, blocks);
        }
    }

    public static Set<Block> getEffectiveBlocks(ItemTool tool) {
        return (Set)ReflectionHelper.getPrivateValue(ItemTool.class, (Object)tool, (String[])ReflectionLib.ITEMTOOL_EFFECTIVE_BLOCKS);
    }

    public static void setToolAsEffectiveAgainst(ItemTool tool, Block ... blocks) {
        Set<Block> effectiveOn = ToolsManager.getEffectiveBlocks(tool);
        Collections.addAll(effectiveOn, blocks);
    }

    public static float getSpeed(ItemStack stack) {
        Item.ToolMaterial material = ToolsManager.getToolMaterial(stack);
        if (material != null) {
            return material.getEfficiency();
        }
        return 1.0f;
    }

    public static float getSpeed(ItemStack stack, IBlockState state) {
        if (!stack.isEmpty() && stack.getItem() instanceof ItemTool) {
            ItemTool tool = (ItemTool)stack.getItem();
            return tool.getDestroySpeed(stack, state);
        }
        return 1.0f;
    }
}

