/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public final class WorldUtils {
    private static final HashSet<Material> SOLID_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.ROCK, Material.ANVIL, Material.GLASS, Material.IRON, Material.ICE, Material.PACKED_ICE, Material.REDSTONE_LIGHT, Material.PISTON});

    private WorldUtils() {
    }

    public static boolean isSolid(World world, BlockPos pos, EnumFacing facing, IBlockState state) {
        return SOLID_MATERIALS.contains(state.getMaterial()) && state.getBlockFaceShape((IBlockAccess)world, pos, facing.getOpposite()) == BlockFaceShape.SOLID;
    }

    public static int getNaturalLightFromNeighbors(World worldIn, BlockPos pos) {
        return WorldUtils.getNaturalLight(worldIn, pos, true, 0);
    }

    private static int getNaturalLight(World worldIn, BlockPos pos, boolean checkNeighbors, int amount) {
        if (pos.getX() >= -30000000 && pos.getZ() >= -30000000 && pos.getX() < 30000000 && pos.getZ() < 30000000) {
            if (checkNeighbors && worldIn.getBlockState(pos).useNeighborBrightness()) {
                int i1 = WorldUtils.getNaturalLight(worldIn, pos.up(), false, 0);
                int i = WorldUtils.getNaturalLight(worldIn, pos.east(), false, 0);
                int j = WorldUtils.getNaturalLight(worldIn, pos.west(), false, 0);
                int k = WorldUtils.getNaturalLight(worldIn, pos.south(), false, 0);
                int l = WorldUtils.getNaturalLight(worldIn, pos.north(), false, 0);
                if (i > i1) {
                    i1 = i;
                }
                if (j > i1) {
                    i1 = j;
                }
                if (k > i1) {
                    i1 = k;
                }
                if (l > i1) {
                    i1 = l;
                }
                return i1;
            }
            if (pos.getY() < 0) {
                return 0;
            }
            if (pos.getY() >= 256) {
                pos = new BlockPos(pos.getX(), 255, pos.getZ());
            }
            Chunk chunk = worldIn.getChunkFromBlockCoords(pos);
            return WorldUtils.getNaturalLightSubtracted(chunk, pos, amount);
        }
        return 15;
    }

    private static int getNaturalLightSubtracted(Chunk chunkIn, BlockPos pos, int amount) {
        int l;
        int i = pos.getX() & 0xF;
        int j = pos.getY();
        int k = pos.getZ() & 0xF;
        ExtendedBlockStorage extendedblockstorage = chunkIn.getBlockStorageArray()[j >> 4];
        if (extendedblockstorage == Chunk.NULL_BLOCK_STORAGE) {
            return chunkIn.getWorld().provider.hasSkyLight() && amount < EnumSkyBlock.SKY.defaultLightValue ? EnumSkyBlock.SKY.defaultLightValue - amount : 0;
        }
        int n = l = !chunkIn.getWorld().provider.hasSkyLight() ? 0 : extendedblockstorage.getSkyLight(i, j & 0xF, k);
        if ((l -= amount) < 0) {
            l = 0;
        }
        return l;
    }

    public static double getDistance(BlockPos pos1, BlockPos pos2) {
        assert (pos1 != null);
        assert (pos2 != null);
        return new Vec3d((Vec3i)pos1).distanceTo(new Vec3d((Vec3i)pos2));
    }

    public static boolean spawnGhast(World world, BlockPos pos) {
        EntityGhast ghast = new EntityGhast(world);
        double failures = 1.0;
        for (int i = 0; i < 200; ++i) {
            double xPos = (double)pos.getX() + (world.rand.nextDouble() - world.rand.nextDouble()) * Math.max(20.0, failures);
            double yPos = (double)pos.getY() + failures;
            double zPos = (double)pos.getZ() + (world.rand.nextDouble() - world.rand.nextDouble()) * Math.max(20.0, failures);
            ghast.setLocationAndAngles(xPos, yPos, zPos, world.rand.nextFloat() * 360.0f, 0.0f);
            AxisAlignedBB box = ghast.getEntityBoundingBox().offset(ghast.getPosition().up(5));
            boolean blocked = StreamSupport.stream(BlockPos.MutableBlockPos.getAllInBox((BlockPos)WorldUtils.getMin(box), (BlockPos)WorldUtils.getMax(box)).spliterator(), false).anyMatch(p -> !world.isAirBlock(p));
            if (!blocked) {
                return world.spawnEntity((Entity)ghast);
            }
            failures += 1.0;
        }
        return false;
    }

    public static boolean isWater(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        return state.getBlock() == Blocks.WATER || state.getBlock() == Blocks.FLOWING_WATER;
    }

    public static boolean isWaterSource(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        return state.getBlock() == Blocks.WATER && (Integer)state.getValue((IProperty)BlockLiquid.LEVEL) == 0;
    }

    public static AxisAlignedBB toInts(AxisAlignedBB box) {
        return new AxisAlignedBB((double)((int)box.minX), (double)((int)box.minY), (double)((int)box.minZ), (double)((int)box.maxX), (double)((int)box.maxY), (double)((int)box.maxZ));
    }

    public static Set<BlockPos> getPosAround(BlockPos pos, EnumFacing.Axis axis) {
        HashSet posSet = Sets.newHashSet();
        for (int i = -1; i <= 1; ++i) {
            block6: for (int j = -1; j <= 1; ++j) {
                switch (axis) {
                    case X: {
                        posSet.add(pos.add(0, i, j));
                        continue block6;
                    }
                    case Y: {
                        posSet.add(pos.add(i, 0, j));
                        continue block6;
                    }
                    case Z: {
                        posSet.add(pos.add(i, j, 0));
                    }
                }
            }
        }
        return posSet;
    }

    public static BlockPos getMin(AxisAlignedBB box) {
        return new BlockPos(box.minX, box.minY, box.minZ);
    }

    public static BlockPos getMax(AxisAlignedBB box) {
        return new BlockPos(box.maxX, box.maxY, box.maxZ);
    }

    public static boolean matches(IBlockState a, IBlockState b) {
        return b == null || a.equals(b);
    }

    public static void addDrop(LivingDropsEvent evt, ItemStack drop) {
        EntityItem item = new EntityItem(evt.getEntityLiving().getEntityWorld(), evt.getEntityLiving().posX, evt.getEntityLiving().posY, evt.getEntityLiving().posZ, drop);
        item.setDefaultPickupDelay();
        evt.getDrops().add(item);
    }

    public static boolean isPast(World world, TimeFrame frame) {
        return frame.start < WorldUtils.getDayTicks(world);
    }

    public static boolean isTimeFrame(World world, TimeFrame frame) {
        return frame.isBetween(WorldUtils.getDayTicks(world));
    }

    public static boolean isMoonPhase(World world, MoonPhase phase) {
        return phase.ordinal() == world.provider.getMoonPhase(world.getWorldTime());
    }

    public static int getDayTicks(World world) {
        return (int)((double)world.getWorldTime() % Time.DAY.getTicks());
    }

    public static enum TimeFrame {
        DAWN(0, 3600),
        NOON(5000, 7000),
        DUSK(10200, 12700),
        MIDNIGHT(17000, 19000),
        NIGHT(13001, 24000),
        DAY(0, 13000);

        private static final Random rand;
        private int start;
        private int end;

        private TimeFrame(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean isBetween(int time) {
            return time >= this.start && time <= this.end;
        }

        public int randomBetween() {
            return rand.nextInt(this.end - this.start + 1) + this.start;
        }

        static {
            rand = new Random();
        }
    }

    public static enum Time {
        SECOND(0.27),
        MINUTE(16.6),
        HOUR(1000.0),
        DAY(24000.0);

        private double ticks;

        private Time(double ticks) {
            this.ticks = ticks;
        }

        public double getTicks() {
            return this.ticks;
        }
    }

    public static enum MoonPhase {
        Full,
        WaningGibbous,
        LastQuarter,
        WaningCrescent,
        New,
        WaxingCrescent,
        FirstQuarter,
        WaxingGibbous;

    }
}

