/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class StackEjector {
    private final World world;
    private final ItemStack stack;
    private Vec3d position;
    private Vec3d motion;
    private int pickupDelay;

    public StackEjector(@Nonnull World world, @Nonnull ItemStack stack, Vec3d position, Vec3d motion) {
        this.world = world;
        this.stack = stack;
        this.position = position;
        this.motion = motion;
    }

    public StackEjector(@Nonnull World world, @Nonnull ItemStack stack, Vec3d position) {
        this.world = world;
        this.stack = stack;
        this.position = position;
    }

    public void ejectStack() {
        if (this.world.isRemote) {
            return;
        }
        if (this.stack == null) {
            return;
        }
        if (this.position == null) {
            return;
        }
        EntityItem item = new EntityItem(this.world, this.position.x, this.position.y, this.position.z, this.stack);
        item.setPickupDelay(this.pickupDelay);
        if (this.motion != null) {
            item.motionX = this.motion.x;
            item.motionY = this.motion.y;
            item.motionZ = this.motion.z;
        }
        this.world.spawnEntity((Entity)item);
    }

    public void setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }
}

