/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.api.capabilities.CapabilityAxle;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.util.IMechanicalUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MechanicalUtil
implements IMechanicalUtil {
    @Override
    public boolean isRedstonePowered(World world, BlockPos pos) {
        return world.isBlockIndirectlyGettingPowered(pos) > 0;
    }

    @Override
    public IMechanicalPower getMechanicalPower(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile != null && tile.hasCapability(CapabilityMechanicalPower.MECHANICAL_POWER, facing)) {
            return (IMechanicalPower)tile.getCapability(CapabilityMechanicalPower.MECHANICAL_POWER, facing);
        }
        return null;
    }

    @Override
    public boolean canInput(World world, BlockPos pos, EnumFacing facing) {
        IMechanicalPower power = this.getMechanicalPower(world, pos, facing);
        return power != null && power.getMaximumInput(facing) > 0;
    }

    @Override
    public boolean isAxle(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IAxle axle = this.getAxle(world, pos, facing);
        return axle != null && axle.getAxis() == facing.getAxis();
    }

    @Override
    public IAxle getAxle(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile != null && tile.hasCapability(CapabilityAxle.AXLE, facing)) {
            return (IAxle)tile.getCapability(CapabilityAxle.AXLE, facing);
        }
        return null;
    }

    @Override
    public int getPowerOutput(World world, BlockPos pos, EnumFacing facing) {
        IMechanicalPower power = this.getMechanicalPower(world, pos, facing);
        if (power != null) {
            return power.getMechanicalOutput(facing);
        }
        return 0;
    }
}

