/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.util.InventoryIterator;
import betterwithmods.util.StackEjector;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.VectorBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class InvUtils {
    public static boolean containsIngredient(List<Ingredient> collection, List<Ingredient> ingredient) {
        return InvUtils.matchesPredicate(collection, ingredient, (a, b) -> {
            if (a.getMatchingStacks().length > 0) {
                return Arrays.stream(a.getMatchingStacks()).allMatch(arg_0 -> ((Ingredient)b).apply(arg_0));
            }
            return false;
        });
    }

    public static boolean isIngredientValid(Ingredient ingredient) {
        return ArrayUtils.isEmpty((Object[])ingredient.getMatchingStacks());
    }

    public static boolean containsIngredient(ItemStackHandler handler, Ingredient ingredient) {
        return InventoryIterator.stream(handler).anyMatch(arg_0 -> ((Ingredient)ingredient).apply(arg_0));
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return !stack.isEmpty() && (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null));
    }

    public static <T> NonNullList<T> asNonnullList(T ... array) {
        NonNullList nonNullList = NonNullList.create();
        if (array != null) {
            nonNullList.addAll((Collection)Arrays.stream(array).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return nonNullList;
    }

    public static <T> NonNullList<T> asNonnullList(List<T> list) {
        NonNullList nonNullList = NonNullList.create();
        if (list != null) {
            nonNullList.addAll((Collection)list.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return nonNullList;
    }

    public static void givePlayer(EntityPlayer player, EnumFacing inv, NonNullList<ItemStack> stacks) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        if (inventory != null) {
            InvUtils.insert((IItemHandler)inventory, stacks, false);
        }
    }

    public static boolean usePlayerItemStrict(EntityPlayer player, EnumFacing inv, Ingredient ingredient, int amount) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        return inventory != null && InvUtils.consumeItemsInInventoryStrict(inventory, ingredient, amount, false);
    }

    public static boolean usePlayerItem(EntityPlayer player, EnumFacing inv, ItemStack stack, int amount) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        return inventory != null && InvUtils.consumeItemsInInventory((IItemHandler)inventory, stack, amount, false);
    }

    public static boolean usePlayerItem(EntityPlayer player, EnumFacing inv, Ingredient ingredient) {
        IItemHandlerModifiable inventory = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv);
        boolean result = false;
        if (inventory != null) {
            NonNullList containers = NonNullList.create();
            result = InvUtils.consumeItemsInInventory((IItemHandler)inventory, ingredient, false, (NonNullList<ItemStack>)containers);
            InvUtils.givePlayer(player, inv, (NonNullList<ItemStack>)containers);
        }
        return result;
    }

    public static Optional<IItemHandler> getItemHandler(World world, BlockPos pos, EnumFacing facing) {
        if (!world.isRemote) {
            TileEntity tile = world.getTileEntity(pos);
            if (tile != null) {
                return Optional.ofNullable(tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            }
            List entities = world.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)), entity -> entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            Optional entity2 = entities.stream().findFirst();
            if (entity2.isPresent()) {
                return Optional.ofNullable(((Entity)entity2.get()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
            }
        }
        return Optional.ofNullable(null);
    }

    public static void ejectInventoryContents(World world, BlockPos pos, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            InvUtils.ejectStackWithOffset(world, pos, inv.getStackInSlot(i));
        }
    }

    public static void clearInventory(IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            inv.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public static void copyTags(ItemStack destStack, ItemStack sourceStack) {
        if (sourceStack.hasTagCompound()) {
            destStack.setTagCompound(sourceStack.getTagCompound().copy());
        }
    }

    public static ItemStack decrStackSize(IItemHandlerModifiable inv, int slot, int amount) {
        if (!inv.getStackInSlot(slot).isEmpty()) {
            if (inv.getStackInSlot(slot).getCount() <= amount) {
                ItemStack splitStack = inv.getStackInSlot(slot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
                return splitStack;
            }
            ItemStack splitStack = inv.getStackInSlot(slot).splitStack(amount);
            if (inv.getStackInSlot(slot).getCount() < 1) {
                inv.setStackInSlot(slot, ItemStack.EMPTY);
            }
            return splitStack;
        }
        return null;
    }

    public static ItemStack insertSingle(IItemHandler inv, ItemStack stack, boolean simulate) {
        return InvUtils.insert(inv, stack, 1, simulate);
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, int count, boolean simulate) {
        ItemStack copy = stack.copy();
        if (copy.getCount() > count) {
            copy.setCount(count);
        }
        return InvUtils.insert(inv, copy, simulate);
    }

    public static boolean canInsert(IItemHandler inv, ItemStack stack, int count) {
        ItemStack inserted;
        ItemStack copy = stack.copy();
        if (copy.getCount() > count) {
            copy.setCount(count);
        }
        return !(inserted = InvUtils.insert(inv, copy, true)).equals(copy);
    }

    public static void insert(IItemHandler inv, NonNullList<ItemStack> stacks, boolean simulate) {
        stacks.forEach(stack -> InvUtils.insert(inv, stack, 0, inv.getSlots(), simulate));
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, boolean simulate) {
        return InvUtils.insert(inv, stack, 0, inv.getSlots(), simulate);
    }

    public static ItemStack insert(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        return InvUtils.attemptInsert(inv, stack, minSlot, maxSlot, simulate);
    }

    public static ItemStack attemptInsert(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        if (InvUtils.isFull(inv)) {
            return stack;
        }
        for (int slot = minSlot; slot < maxSlot && !(stack = inv.insertItem(slot, stack, simulate)).isEmpty(); ++slot) {
        }
        return stack;
    }

    public static boolean insertFromWorld(IItemHandler inv, EntityItem entity, int minSlot, int maxSlot, boolean simulate) {
        ItemStack stack = entity.getItem().copy();
        ItemStack leftover = InvUtils.attemptInsert(inv, stack, minSlot, maxSlot, simulate);
        if (leftover.isEmpty()) {
            entity.setDead();
            return true;
        }
        entity.setItem(leftover);
        return false;
    }

    public static boolean isFull(IItemHandler inv) {
        boolean full = true;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.getCount() == inv.getSlotLimit(slot)) continue;
            full = false;
            break;
        }
        return full;
    }

    public static int getFirstOccupiedStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.getStackInSlot(slot).isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstEmptyStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (!inv.getStackInSlot(slot).isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    public static int getOccupiedStacks(IItemHandler inv) {
        return InvUtils.getOccupiedStacks(inv, 0, inv.getSlots() - 1);
    }

    public static int getOccupiedStacks(IItemHandler inv, int min, int max) {
        int count = 0;
        for (int i = min; i <= max; ++i) {
            if (!inv.getStackInSlot(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countItemStacksInInventory(IItemHandler inv, ItemStack toCheck) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty() || !ItemStack.areItemsEqual((ItemStack)toCheck, (ItemStack)stack) && (toCheck.getItem() != stack.getItem() || toCheck.getItemDamage() != Short.MAX_VALUE)) continue;
            if (toCheck.hasTagCompound()) {
                if (!ItemStack.areItemStackTagsEqual((ItemStack)toCheck, (ItemStack)stack)) continue;
                itemCount += stack.getCount();
                continue;
            }
            itemCount += stack.getCount();
        }
        return itemCount;
    }

    public static int countItemsInInventory(IItemHandler inv, Item item) {
        return InvUtils.countItemsInInventory(inv, item, Short.MAX_VALUE);
    }

    public static int countItemsInInventory(IItemHandler inv, Item item, int meta) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty() || stack.getItem() != item || meta != Short.MAX_VALUE && stack.getItemDamage() != meta) continue;
            itemCount += inv.getStackInSlot(i).getCount();
        }
        return itemCount;
    }

    public static int countOresInInventory(IItemHandler inv, List<ItemStack> list) {
        int ret = 0;
        if (list != null && !list.isEmpty()) {
            for (ItemStack oreStack : list) {
                ret += InvUtils.countItemStacksInInventory(inv, oreStack);
            }
        }
        return ret;
    }

    public static boolean consumeItemsInInventoryStrict(IItemHandlerModifiable inv, Ingredient ingredient, int sizeOfStack, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty() || !ingredient.apply(stack) || stack.getCount() < sizeOfStack) continue;
            InvUtils.decrStackSize(inv, i, sizeOfStack);
            return true;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandler inv, ItemStack toCheck, int sizeOfStack, boolean simulate) {
        boolean extracted = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack inSlot = inv.getStackInSlot(i);
            if (!InvUtils.matches(toCheck, inSlot)) continue;
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)inSlot);
            if (inv.extractItem(i, sizeOfStack, simulate).getCount() < sizeOfStack) continue;
            extracted = true;
            InvUtils.insert(inv, container, false);
            break;
        }
        return extracted;
    }

    public static boolean consumeItemsInInventory(IItemHandler inv, Ingredient ingredient, boolean simulate, NonNullList<ItemStack> containers) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack inSlot = inv.getStackInSlot(i);
            if (!ingredient.apply(inSlot)) continue;
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)inSlot);
            if (!container.isEmpty()) {
                containers.add((Object)container);
            }
            int count = ingredient instanceof StackIngredient ? ((StackIngredient)ingredient).getCount(inSlot) : 1;
            return inv.extractItem(i, count, simulate).getCount() >= count;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandler inv, StackIngredient ingredient, boolean simulate, NonNullList<ItemStack> containers) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack inSlot = inv.getStackInSlot(i);
            if (!ingredient.apply(inSlot)) continue;
            int sizeOfStack = ingredient.getCount(inSlot);
            ItemStack container = ForgeHooks.getContainerItem((ItemStack)inSlot);
            if (!container.isEmpty()) {
                containers.add((Object)container);
            }
            return inv.extractItem(i, sizeOfStack, simulate).getCount() >= sizeOfStack;
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandlerModifiable inv, Item item, int meta, int stackSize) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty() || stack.getItem() != item || meta != Short.MAX_VALUE && stack.getItemDamage() != meta) continue;
            if (stack.getCount() >= stackSize) {
                InvUtils.decrStackSize(inv, i, stackSize);
                return false;
            }
            stackSize -= stack.getCount();
            inv.setStackInSlot(i, ItemStack.EMPTY);
        }
        return false;
    }

    public static boolean consumeOresInInventory(IItemHandlerModifiable inv, List<?> list, int stackSize) {
        if (list.size() > 0) {
            for (Object aList : list) {
                ItemStack tempStack = (ItemStack)aList;
                Item item = tempStack.getItem();
                int meta = tempStack.getItemDamage();
                for (int j = 0; j < inv.getSlots(); ++j) {
                    ItemStack stack = inv.getStackInSlot(j);
                    if (stack.isEmpty() || stack.getItem() != item || stack.getItemDamage() != meta && meta != Short.MAX_VALUE) continue;
                    if (tempStack.hasTagCompound()) {
                        if (!ItemStack.areItemStackTagsEqual((ItemStack)tempStack, (ItemStack)stack)) continue;
                        if (stack.getCount() >= stackSize) {
                            InvUtils.decrStackSize(inv, j, stackSize);
                            return false;
                        }
                        stackSize -= stack.getCount();
                        inv.setStackInSlot(j, ItemStack.EMPTY);
                        continue;
                    }
                    if (stack.getCount() >= stackSize) {
                        InvUtils.decrStackSize(inv, j, stackSize);
                        return false;
                    }
                    stackSize -= stack.getCount();
                    inv.setStackInSlot(j, ItemStack.EMPTY);
                }
            }
        }
        return false;
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item) {
        return InvUtils.getFirstOccupiedStackNotOfItem(inv, item, Short.MAX_VALUE);
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item, int meta) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).isEmpty()) continue;
            int tempMeta = inv.getStackInSlot(i).getItemDamage();
            if (inv.getStackInSlot(i).getItem() == item || meta != Short.MAX_VALUE && tempMeta == meta) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, Item item) {
        return InvUtils.getFirstOccupiedStackOfItem(inv, item);
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, ItemStack stack) {
        return InvUtils.getFirstOccupiedStackOfItem(inv, StackIngredient.fromStacks(stack));
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, Ingredient ingred) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).isEmpty() || !ingred.apply(inv.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean spawnStack(World world, BlockPos pos, List<ItemStack> stacks) {
        boolean spawned = true;
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || InvUtils.spawnStack(world, pos, stack, 10)) continue;
            spawned = false;
        }
        return spawned;
    }

    public static boolean spawnStack(World world, BlockPos pos, ItemStack stack, int pickupDelay) {
        return InvUtils.spawnStack(world, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), stack, pickupDelay);
    }

    public static boolean spawnStack(World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        EntityItem item = new EntityItem(world, x, y, z, stack);
        item.motionX = 0.0;
        item.motionY = 0.0;
        item.motionZ = 0.0;
        item.setPickupDelay(pickupDelay);
        return world.spawnEntity((Entity)item);
    }

    public static void spawnStack(World world, double x, double y, double z, int count, ItemStack stack) {
        ItemStack copy = stack.copy();
        if (copy.getCount() > count) {
            copy.setCount(count);
        }
        InvUtils.spawnStack(world, x, y, z, copy, 10);
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.copy());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.copy());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        VectorBuilder builder = new VectorBuilder();
        new StackEjector(world, stack, builder.set((Vec3i)pos).rand(0.5).offset(0.25).build(), builder.setGaussian(0.05f).build()).ejectStack();
    }

    public static void ejectStack(@Nonnull World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        if (world.isRemote) {
            return;
        }
        VectorBuilder builder = new VectorBuilder();
        StackEjector ejector = new StackEjector(world, stack, builder.set(x, y, z).build());
        ejector.setPickupDelay(pickupDelay);
        ejector.ejectStack();
    }

    public static void ejectStack(@Nonnull World world, double x, double y, double z, ItemStack stack) {
        InvUtils.ejectStack(world, x, y, z, stack, 10);
    }

    public static void ejectBrokenItems(World world, BlockPos pos, ResourceLocation lootLocation) {
        if (!world.isRemote) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world);
            List stacks = world.getLootTableManager().getLootTableFromLocation(lootLocation).generateLootForPools(world.rand, build.build());
            if (!stacks.isEmpty()) {
                InvUtils.ejectStackWithOffset(world, pos, stacks);
            }
        }
    }

    public static void writeToStack(IItemHandler inv, ItemStack stack) {
        NonNullList list = NonNullList.withSize((int)inv.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).isEmpty()) continue;
            list.set(i, (Object)inv.getStackInSlot(i).copy());
        }
        NBTTagCompound tag = ItemStackHelper.saveAllItems((NBTTagCompound)new NBTTagCompound(), (NonNullList)list);
        if (!tag.hasNoTags()) {
            stack.setTagCompound(tag);
        }
    }

    public static void readFromStack(IItemHandler inv, ItemStack stack) {
        if (!stack.isEmpty() && stack.hasTagCompound()) {
            NonNullList list = NonNullList.withSize((int)inv.getSlots(), (Object)ItemStack.EMPTY);
            NBTTagCompound tag = stack.getTagCompound();
            if (tag != null) {
                ItemStackHelper.loadAllItems((NBTTagCompound)tag, (NonNullList)list);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    inv.insertItem(i, (ItemStack)list.get(i), false);
                }
            }
        }
    }

    public static int calculateComparatorLevel(@Nonnull IItemHandler inventory) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)itemstack.getMaxStackSize();
            ++i;
        }
        return MathHelper.floor((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static ItemStack setCount(ItemStack input, int count) {
        if (input.isEmpty()) {
            return input;
        }
        ItemStack stack = input.copy();
        stack.setCount(count);
        return stack;
    }

    public static boolean matches(ItemStack one, ItemStack two) {
        if (one.isItemEqual(two)) {
            return true;
        }
        return one.getItem() == two.getItem() && (one.getMetadata() == Short.MAX_VALUE || two.getMetadata() == Short.MAX_VALUE);
    }

    public static boolean matchesSize(ItemStack one, ItemStack two) {
        return one.getCount() == two.getCount() && InvUtils.matches(one, two);
    }

    public static <T> boolean matchesPredicate(List<T> oneList, List<T> twoList, BiPredicate<T, T> matches) {
        if (oneList.size() != twoList.size()) {
            return false;
        }
        HashSet<Object> alreadyMatched = new HashSet<Object>();
        for (Object one : oneList) {
            Optional<Object> found = twoList.stream().filter(two -> !alreadyMatched.contains(two) && matches.test(one, two)).findFirst();
            if (found.isPresent()) {
                alreadyMatched.add(found.get());
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesExact(List<ItemStack> oneList, List<ItemStack> twoList) {
        return InvUtils.matchesPredicate(oneList, twoList, InvUtils::matchesSize);
    }

    public static boolean matches(List<ItemStack> oneList, List<ItemStack> twoList) {
        return InvUtils.matchesPredicate(oneList, twoList, InvUtils::matches);
    }

    public static <T> List<List<T>> splitIntoBoxes(List<T> stacks, int boxes) {
        ArrayList<List<T>> splitStacks = new ArrayList<List<T>>();
        int i = 0;
        while (i < boxes) {
            int finalI = i++;
            splitStacks.add(IntStream.range(0, stacks.size()).filter(index -> index % boxes == finalI).mapToObj(stacks::get).collect(Collectors.toList()));
        }
        return splitStacks;
    }

    public static boolean isEmpty(IItemHandler inventory) {
        int inventorySize = inventory.getSlots();
        for (int i = 0; i < inventorySize; ++i) {
            if (inventory.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

