/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class AABBArray
extends AxisAlignedBB {
    private AxisAlignedBB[] boundingBoxes;

    public AABBArray(AxisAlignedBB ... boundingBoxes) {
        this(AABBArray.join(boundingBoxes));
        this.boundingBoxes = boundingBoxes;
        this.boundingBoxes = AABBArray.getParts(this);
    }

    private AABBArray(AxisAlignedBB full) {
        super(full.minX, full.minY, full.minZ, full.maxX, full.maxY, full.maxZ);
    }

    private static AxisAlignedBB join(AxisAlignedBB[] in) {
        if (in.length == 0) {
            return null;
        }
        AxisAlignedBB aabb1 = in[0];
        for (int i = 1; i < in.length; ++i) {
            aabb1 = aabb1.union(in[i]);
        }
        return aabb1;
    }

    public static AxisAlignedBB[] getParts(AxisAlignedBB source) {
        if (source instanceof AABBArray) {
            HashSet bbs = new HashSet();
            Arrays.asList(((AABBArray)source).boundingBoxes).forEach((? super T aabb) -> bbs.addAll(Arrays.asList(AABBArray.getParts(aabb))));
            return bbs.toArray(new AxisAlignedBB[0]);
        }
        return new AxisAlignedBB[]{source};
    }

    public static AxisAlignedBB toAABB(AxisAlignedBB source) {
        return new AxisAlignedBB(source.minX, source.minY, source.minZ, source.maxX, source.maxY, source.maxZ);
    }

    public boolean intersects(Vec3d p_189973_1_, Vec3d p_189973_2_) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            flag |= axisAlignedBB.intersects(p_189973_1_, p_189973_2_);
        }
        return flag;
    }

    public boolean intersects(double x1, double y1, double z1, double x2, double y2, double z2) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.intersects(x1, y1, z1, x2, y2, z2);
        }
        return flag;
    }

    public AABBArray addBoundingBox(AxisAlignedBB aabb) {
        AxisAlignedBB[] bbs = new AxisAlignedBB[this.boundingBoxes.length + 1];
        bbs[bbs.length] = aabb;
        return new AABBArray(bbs);
    }

    public AABBArray offset(double x, double y, double z) {
        AxisAlignedBB[] parts = AABBArray.getParts(this);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].offset(x, y, z);
        }
        return new AABBArray(parts);
    }

    public double calculateXOffset(AxisAlignedBB other, double offsetX) {
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            offsetX = axisAlignedBB.calculateXOffset(other, offsetX);
        }
        return offsetX;
    }

    public double calculateYOffset(AxisAlignedBB other, double offsetY) {
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            offsetY = axisAlignedBB.calculateYOffset(other, offsetY);
        }
        return offsetY;
    }

    public double calculateZOffset(AxisAlignedBB other, double offsetZ) {
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            offsetZ = axisAlignedBB.calculateZOffset(other, offsetZ);
        }
        return offsetZ;
    }

    public boolean intersectsWithXY(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.intersects(other.minX, other.minY, Double.NEGATIVE_INFINITY, other.maxX, other.maxY, Double.POSITIVE_INFINITY);
        }
        return flag;
    }

    public boolean intersectsWithXZ(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.intersects(other.minX, Double.NEGATIVE_INFINITY, other.minZ, other.maxX, Double.POSITIVE_INFINITY, other.maxZ);
        }
        return flag;
    }

    public boolean intersectsWithYZ(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.intersects(Double.NEGATIVE_INFINITY, other.minY, other.minZ, Double.POSITIVE_INFINITY, other.maxY, other.maxZ);
        }
        return flag;
    }

    public boolean intersects(AxisAlignedBB other) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : this.boundingBoxes) {
            flag |= axisAlignedBB.intersects(other);
        }
        return flag;
    }

    public boolean contains(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.contains(vec);
        }
        return flag;
    }

    public boolean intersectsWithXY(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.intersectsWithXY(vec);
        }
        return flag;
    }

    public boolean intersectsWithXZ(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.intersectsWithXZ(vec);
        }
        return flag;
    }

    public boolean intersectsWithYZ(Vec3d vec) {
        boolean flag = false;
        for (AxisAlignedBB axisAlignedBB : AABBArray.getParts(this)) {
            flag |= axisAlignedBB.intersectsWithYZ(vec);
        }
        return flag;
    }

    public AxisAlignedBB grow(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return new AABBArray(this.boundingBoxes);
        }
        return super.grow(x, y, z);
    }

    public AxisAlignedBB grow(double value) {
        return this.grow(value, value, value);
    }

    public RayTraceResult calculateIntercept(Vec3d vecA, Vec3d vecB) {
        AxisAlignedBB axisAlignedBB;
        RayTraceResult result = null;
        AxisAlignedBB[] axisAlignedBBArray = AABBArray.getParts(this);
        int n = axisAlignedBBArray.length;
        for (int i = 0; i < n && (result = (axisAlignedBB = axisAlignedBBArray[i]).calculateIntercept(vecA, vecB)) == null; ++i) {
        }
        return result;
    }

    public AABBArray forEach(Function<AxisAlignedBB, AxisAlignedBB> consumer) {
        AxisAlignedBB[] var1 = AABBArray.getParts(this);
        for (int i = 0; i < var1.length; ++i) {
            var1[i] = consumer.apply(var1[i]);
        }
        return new AABBArray(var1);
    }

    public AxisAlignedBB expand(double x, double y, double z) {
        return super.expand(x, y, z);
    }

    public AxisAlignedBB shrink(double value) {
        return super.shrink(value);
    }

    public AxisAlignedBB offset(BlockPos pos) {
        return super.offset(pos);
    }

    public AxisAlignedBB setMaxY(double y2) {
        return super.setMaxY(y2);
    }

    public AxisAlignedBB union(AxisAlignedBB other) {
        return super.union(other);
    }
}

