/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageDataHandler<DataType> {
    private static final List<MessageDataHandler<?>> handlers = Lists.newArrayList();
    private Function<ByteBuf, DataType> reader;
    private BiConsumer<ByteBuf, DataType> writer;
    private Class<DataType> type;

    private MessageDataHandler(Class<DataType> type, Function<ByteBuf, DataType> reader, BiConsumer<ByteBuf, DataType> writer) {
        this.reader = reader;
        this.writer = writer;
        this.type = type;
    }

    @ParametersAreNonnullByDefault
    private static <DataType> void addHandler(Class<DataType> type, Function<ByteBuf, DataType> reader, BiConsumer<ByteBuf, DataType> writer) {
        handlers.add(new MessageDataHandler<DataType>(type, reader, writer));
    }

    public static MessageDataHandler getHandler(@Nonnull Class type) {
        for (MessageDataHandler<?> handler : handlers) {
            if (!super.typeMatches(type)) continue;
            return handler;
        }
        throw new RuntimeException("Cannot read packet data! Unsupported data type!");
    }

    public DataType read(@Nonnull ByteBuf buf) {
        return this.reader.apply(buf);
    }

    public void write(@Nonnull ByteBuf buf, @Nonnull DataType data) {
        this.writer.accept(buf, data);
    }

    private boolean typeMatches(Class<?> clazz) {
        if (Primitives.isWrapperType(clazz)) {
            clazz = Primitives.unwrap(clazz);
        }
        return clazz.equals(this.type) || this.type.isAssignableFrom(clazz);
    }

    static {
        MessageDataHandler.addHandler(Byte.TYPE, ByteBuf::readByte, (buf, data) -> buf.writeByte((int)data.byteValue()));
        MessageDataHandler.addHandler(Short.TYPE, ByteBuf::readShort, (buf, data) -> buf.writeShort((int)data.shortValue()));
        MessageDataHandler.addHandler(Integer.TYPE, ByteBuf::readInt, ByteBuf::writeInt);
        MessageDataHandler.addHandler(Long.TYPE, ByteBuf::readLong, ByteBuf::writeLong);
        MessageDataHandler.addHandler(Double.TYPE, ByteBuf::readDouble, ByteBuf::writeDouble);
        MessageDataHandler.addHandler(Float.TYPE, ByteBuf::readFloat, ByteBuf::writeFloat);
        MessageDataHandler.addHandler(Boolean.TYPE, ByteBuf::readBoolean, ByteBuf::writeBoolean);
        MessageDataHandler.addHandler(Character.TYPE, ByteBuf::readChar, (buf, data) -> buf.writeChar((int)data.charValue()));
        MessageDataHandler.addHandler(String.class, ByteBufUtils::readUTF8String, ByteBufUtils::writeUTF8String);
        MessageDataHandler.addHandler(NBTTagCompound.class, ByteBufUtils::readTag, ByteBufUtils::writeTag);
        MessageDataHandler.addHandler(ItemStack.class, ByteBufUtils::readItemStack, ByteBufUtils::writeItemStack);
        MessageDataHandler.addHandler(BlockPos.class, buf -> new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), (buf, data) -> {
            buf.writeInt(data.getX());
            buf.writeInt(data.getY());
            buf.writeInt(data.getZ());
        });
    }
}

