/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.module.Feature;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VisibleStorms
extends Feature {
    public static boolean DUST_STORMS;
    public static boolean SAND_STORMS;
    public static int DUST_PARTICLES;
    public static int AIR_PARTICLES;
    float currentRed;
    float currentGreen;
    float currentBlue;
    float currentDistance;
    float currentDistanceScale;
    float desiredRed;
    float desiredGreen;
    float desiredBlue;
    float desiredDistance;
    float desiredDistanceScale;

    @Override
    public void setupConfig() {
        DUST_STORMS = this.loadPropBool("Dust Storms", "Storms are clearly visible in dry biomes.", true);
        SAND_STORMS = this.loadPropBool("Sand Storms", "Adds a fog change during storms in deserts.", true);
        DUST_PARTICLES = this.loadPropInt("Dust Particle Count", "How many dust particles should be created, too many may contribute to lag.", 2);
        AIR_PARTICLES = this.loadPropInt("Air Particle Count", "How many air particles should be created, too many may contribute to lag.", 3);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent tickEvent) {
        EntityPlayer entity = tickEvent.player;
        if (entity == null) {
            return;
        }
        World world = entity.world;
        if (world == null || !world.isRemote) {
            return;
        }
        if (DUST_STORMS) {
            int i;
            ParticleManager particleManager = Minecraft.getMinecraft().effectRenderer;
            Random random = world.rand;
            BlockPos pos = entity.getPosition();
            int radius = 16;
            for (i = 0; i < DUST_PARTICLES; ++i) {
                BlockPos posGround = pos.add(random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius);
                if (!this.shouldStorm(world, posGround)) continue;
                posGround = world.getHeight(posGround).down();
                IBlockState stateGround = world.getBlockState(posGround);
                Particle particle = particleManager.spawnEffectParticle(EnumParticleTypes.BLOCK_DUST.getParticleID(), (double)posGround.getX() + random.nextDouble(), (double)posGround.getY() + 1.2, (double)posGround.getZ() + random.nextDouble(), -0.5 - random.nextDouble() * 0.6, 0.0, 0.0, new int[]{Block.getStateId((IBlockState)stateGround)});
            }
            for (i = 0; i < AIR_PARTICLES; ++i) {
                Particle particleAir;
                BlockPos posAir = pos.add(random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius);
                if (!world.canSeeSky(posAir) || !this.shouldStorm(world, posAir) || (particleAir = particleManager.spawnEffectParticle(EnumParticleTypes.SMOKE_NORMAL.getParticleID(), (double)posAir.getX() + random.nextDouble(), (double)posAir.getY() + random.nextDouble(), (double)posAir.getZ() + random.nextDouble(), -0.5 - random.nextDouble() * 0.6, 0.0, 0.0, new int[0])) == null) continue;
                particleAir.setRBGColorF(1.0f, 1.0f, 1.0f);
            }
        }
        if (SAND_STORMS) {
            float epsilon = 0.001f;
            if (Math.abs(this.currentDistance - this.desiredDistance) > epsilon) {
                this.currentDistance = (float)((double)this.currentDistance + (double)(this.desiredDistance - this.currentDistance) * 0.2);
            }
            if (Math.abs(this.currentDistanceScale - this.desiredDistanceScale) > epsilon) {
                this.currentDistanceScale = (float)((double)this.currentDistanceScale + (double)(this.desiredDistanceScale - this.currentDistanceScale) * 0.2);
            }
            if (Math.abs(this.currentRed - this.desiredRed) > epsilon) {
                this.currentRed = (float)((double)this.currentRed + (double)(this.desiredRed - this.currentRed) * 0.2);
            }
            if (Math.abs(this.currentGreen - this.desiredGreen) > epsilon) {
                this.currentGreen = (float)((double)this.currentGreen + (double)(this.desiredGreen - this.currentGreen) * 0.2);
            }
            if (Math.abs(this.currentBlue - this.desiredBlue) > epsilon) {
                this.currentBlue = (float)((double)this.currentBlue + (double)(this.desiredBlue - this.currentBlue) * 0.2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogDistance(EntityViewRenderEvent.RenderFogEvent fogEvent) {
        if (!SAND_STORMS) {
            return;
        }
        Entity entity = fogEvent.getEntity();
        World world = entity.world;
        BlockPos pos = entity.getPosition();
        if (world.isRaining()) {
            BlockPos[] probes;
            this.desiredDistance = 0.0f;
            this.desiredDistanceScale = 0.0f;
            int totalweight = 0;
            for (BlockPos probepos : probes = new BlockPos[]{pos, pos.add(1, 0, 0), pos.add(0, 0, 1), pos.add(-1, 0, 0), pos.add(0, 0, -1)}) {
                boolean aboveground = world.canSeeSky(probepos);
                if (this.isDesert(world, probepos) && aboveground) {
                    this.desiredDistance += fogEvent.getFarPlaneDistance() / 3.0f;
                    this.desiredDistanceScale += -1.0f;
                    ++totalweight;
                    continue;
                }
                if (!aboveground) continue;
                this.desiredDistance += fogEvent.getFarPlaneDistance();
                this.desiredDistanceScale += 0.75f;
                ++totalweight;
            }
            this.desiredDistance /= (float)totalweight;
            this.desiredDistanceScale /= (float)totalweight;
        } else {
            this.desiredDistance = fogEvent.getFarPlaneDistance();
            this.desiredDistanceScale = 0.75f;
        }
        if (Math.abs(fogEvent.getFarPlaneDistance() - this.currentDistance) > 0.001f) {
            VisibleStorms.renderFog(fogEvent.getFogMode(), this.currentDistance, this.currentDistanceScale);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogColor(EntityViewRenderEvent.FogColors fogEvent) {
        if (!SAND_STORMS) {
            return;
        }
        Entity entity = fogEvent.getEntity();
        World world = entity.world;
        BlockPos pos = entity.getPosition();
        Color desiredcolor = new Color(Math.min(fogEvent.getRed(), 1.0f), Math.min(fogEvent.getGreen(), 1.0f), Math.min(fogEvent.getBlue(), 1.0f));
        if (world.isRaining()) {
            BlockPos[] probes;
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            int totalweight = 0;
            for (BlockPos probepos : probes = new BlockPos[]{pos, pos.add(1, 0, 0), pos.add(0, 0, 1), pos.add(-1, 0, 0), pos.add(0, 0, -1)}) {
                boolean aboveground = world.canSeeSky(probepos);
                if (this.isDesert(world, probepos)) {
                    Biome biome = world.getBiome(probepos);
                    MapColor mapcolor = biome.topBlock.getMapColor((IBlockAccess)world, probepos);
                    Color color = new Color(mapcolor.colorValue);
                    red += 2.0f * ((float)color.getRed() / 255.0f);
                    green += 2.0f * ((float)color.getGreen() / 255.0f);
                    blue += 2.0f * ((float)color.getBlue() / 255.0f);
                    totalweight += 2;
                    continue;
                }
                if (!aboveground) continue;
                red += fogEvent.getRed();
                green += fogEvent.getGreen();
                blue += fogEvent.getBlue();
                ++totalweight;
            }
            desiredcolor = new Color(Math.min(red / (float)totalweight, 1.0f), Math.min(green / (float)totalweight, 1.0f), Math.min(blue / (float)totalweight, 1.0f));
            fogEvent.setRed(this.currentRed / 255.0f);
            fogEvent.setGreen(this.currentGreen / 255.0f);
            fogEvent.setBlue(this.currentBlue / 255.0f);
        }
        this.desiredRed = desiredcolor.getRed();
        this.desiredGreen = desiredcolor.getGreen();
        this.desiredBlue = desiredcolor.getBlue();
    }

    private boolean shouldStorm(World world, BlockPos pos) {
        Biome biome = world.getBiome(pos);
        return world.isRaining() && !biome.canRain() && !biome.isSnowyBiome();
    }

    private boolean isDesert(World world, BlockPos pos) {
        Biome biome = world.getBiome(pos);
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GlStateManager.setFogStart((float)0.0f);
            GlStateManager.setFogEnd((float)farPlaneDistance);
        } else {
            GlStateManager.setFogEnd((float)farPlaneDistance);
            GlStateManager.setFogStart((float)(farPlaneDistance * farPlaneDistanceScale));
        }
    }
}

