/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.BWMRecipes;
import betterwithmods.module.Feature;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.RandomUtils;

public class MossGeneration
extends Feature {
    private static HashMap<Block, IBlockState> CONVERTED_BLOCKS = new HashMap();
    public static int RADIUS;
    public static int RATE;
    public static boolean DISABLE_VINE_RECIPES;

    public static void addBlockConversion(Block block, IBlockState mossyState) {
        CONVERTED_BLOCKS.put(block, mossyState);
    }

    @Override
    public void setupConfig() {
        RADIUS = this.loadPropInt("Moss radius from the mob spawner", "", 5);
        RATE = this.loadPropInt("Moss grow rate", "1 out of this rate will cause a moss to try to generate", 100);
        DISABLE_VINE_RECIPES = this.loadPropBool("Disable Vine Recipes", "Disables the mossy cobblestone and mossy brick recipes involving vines.", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (DISABLE_VINE_RECIPES) {
            BWMRecipes.removeRecipe("minecraft:mossy_cobblestone");
            BWMRecipes.removeRecipe("minecraft:mossy_stonebrick");
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MossGeneration.addBlockConversion(Blocks.COBBLESTONE, Blocks.MOSSY_COBBLESTONE.getDefaultState());
        MossGeneration.addBlockConversion(Blocks.STONEBRICK, Blocks.STONEBRICK.getDefaultState().withProperty((IProperty)BlockStoneBrick.VARIANT, (Comparable)BlockStoneBrick.EnumType.MOSSY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void generateMossNearSpawner(TickEvent.WorldTickEvent event) {
        List<BlockPos> positions;
        World world = event.world;
        if (world.isRemote || event.phase != TickEvent.Phase.END || event.side != Side.SERVER) {
            return;
        }
        if (world.rand.nextInt(RATE) != 0) {
            return;
        }
        List list = world.loadedTileEntityList;
        synchronized (list) {
            positions = world.loadedTileEntityList.stream().filter(t -> t instanceof TileEntityMobSpawner).map(TileEntity::getPos).collect(Collectors.toList());
        }
        positions.forEach(pos -> {
            BlockPos min = pos.add(-RADIUS, -RADIUS, -RADIUS);
            BlockPos max = pos.add(RADIUS, RADIUS, RADIUS);
            MossGeneration.randomPosition(world, min, max).ifPresent(p -> MossGeneration.getMossyVariant(world.getBlockState(p)).ifPresent(mossy -> world.setBlockState(p, mossy)));
        });
    }

    private static Optional<BlockPos> randomPosition(World world, BlockPos start, BlockPos end) {
        if (world.isAreaLoaded(start, end)) {
            return Optional.of(new BlockPos(MossGeneration.randomRange(start.getX(), end.getX()), MossGeneration.randomRange(start.getY(), end.getY()), MossGeneration.randomRange(start.getZ(), end.getZ())));
        }
        return Optional.empty();
    }

    private static Optional<IBlockState> getMossyVariant(IBlockState state) {
        return Optional.ofNullable(CONVERTED_BLOCKS.get(state.getBlock()));
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Cobblestone or Stonebrick within the spawning radius of a Mob Spawner will randomly grow into the Mossy version.";
    }

    private static int randomRange(int start, int end) {
        int d = end - start;
        return start + RandomUtils.nextInt((int)0, (int)d);
    }
}

