/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.BWRegistry;
import betterwithmods.module.Feature;
import betterwithmods.util.InvUtils;
import java.util.Arrays;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class KilnSmelting
extends Feature {
    private static int oreProductionCount;

    @Override
    public void setupConfig() {
        oreProductionCount = this.loadPropInt("Ore Production Count", "Number of Materials returned from Smelting an Ore in the Kiln", 1);
    }

    @Override
    public void finalInit(FMLPostInitializationEvent event) {
        BWOreDictionary.oreNames.stream().flatMap(ore -> Arrays.stream(ore.getMatchingStacks())).filter(s -> s.getItem() instanceof ItemBlock).forEach(input -> {
            ItemStack output = FurnaceRecipes.instance().getSmeltingResult(input).copy();
            BWRegistry.KILN.addStokedRecipe((ItemStack)input, InvUtils.setCount(output, oreProductionCount));
        });
    }

    @Override
    public String getFeatureDescription() {
        return "Allows Kiln to Smelt Ores";
    }
}

