/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.industry.pollution;

import betterwithmods.module.industry.pollution.IWorldPollution;
import betterwithmods.module.industry.pollution.Pollution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class WorldPollutionCapability {
    @CapabilityInject(value=IWorldPollution.class)
    public static Capability<IWorldPollution> POLLUTION = null;

    public static class Default
    implements IWorldPollution {
        private HashMap<ChunkPos, Float> pollution = new HashMap();
        private HashMap<ChunkPos, Byte> leaves = new HashMap();
        private World world;

        public Default() {
        }

        public Default(World world) {
            this.world = world;
        }

        @Override
        public void calculatePollutionReduction() {
            if (!this.pollution.isEmpty()) {
                for (ChunkPos pos : this.pollution.keySet()) {
                    Chunk chunk = this.world.getChunkProvider().getLoadedChunk(pos.x, pos.z);
                    if (chunk == null) continue;
                    float pollutionMod = 1.0f;
                    Biome biome = Biome.getBiome((int)chunk.getBiomeArray()[127], (Biome)Biomes.PLAINS);
                    for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                        pollutionMod *= this.getPollutionReduction(type);
                    }
                    if (this.world.isRaining() && biome.canRain()) {
                        pollutionMod *= 0.8f;
                    }
                    float stat = this.pollution.get(pos).floatValue() * pollutionMod;
                    if (this.getLeafCount(pos) > 0) {
                        float reduction = (float)this.getLeafCount(pos) * 0.001f;
                        stat -= stat * reduction;
                    }
                    this.pollution.put(pos, Float.valueOf(stat));
                }
            }
        }

        @Override
        public void calculateLeafCount() {
            if (!this.leaves.isEmpty()) {
                for (ChunkPos pos : this.leaves.keySet()) {
                    Chunk chunk = this.world.getChunkProvider().getLoadedChunk(pos.x, pos.z);
                    if (chunk == null) continue;
                    byte leafCount = 0;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            IBlockState state;
                            BlockPos p = pos.getBlock(x, 255, z);
                            if (!(this.world.getBlockState(p = this.world.getHeight(p).down()).getBlock() instanceof BlockLeaves) || !(state = this.world.getBlockState(p)).getProperties().containsKey((Object)BlockLeaves.DECAYABLE) || !((Boolean)state.getValue((IProperty)BlockLeaves.DECAYABLE)).booleanValue()) continue;
                            leafCount = (byte)(leafCount + 1);
                        }
                    }
                    this.setLeafCount(pos, leafCount);
                }
            }
        }

        private float getPollutionReduction(BiomeDictionary.Type type) {
            return Pollution.handler.biomeMods.getOrDefault(type.getName(), Float.valueOf(1.0f)).floatValue();
        }

        @Override
        public float getPollution(ChunkPos pos) {
            return this.pollution.containsKey(pos) ? this.pollution.get(pos).floatValue() : -1.0f;
        }

        @Override
        public void removePollution(ChunkPos pos) {
            if (this.pollution.containsKey(pos)) {
                this.pollution.remove(pos);
            }
            if (this.leaves.containsKey(pos)) {
                this.leaves.remove(pos);
            }
        }

        @Override
        public void setPollution(ChunkPos pos, float value) {
            if (value < 0.0f) {
                value = 0.0f;
            }
            this.pollution.put(pos, Float.valueOf(value));
        }

        @Override
        public void calculatePollutionSpread() {
            if (!this.pollution.isEmpty()) {
                ArrayList<ChunkPos> toUpdate = new ArrayList<ChunkPos>();
                for (ChunkPos pos : this.pollution.keySet()) {
                    Random rand;
                    Chunk chunk = this.world.getChunkFromChunkCoords(pos.x, pos.z);
                    if (!chunk.isLoaded() || (rand = chunk.getRandomWithSeed(9850327L)).nextInt(30) != 0) continue;
                    toUpdate.add(pos);
                }
                if (!toUpdate.isEmpty()) {
                    this.calculatePollutionSpread(toUpdate);
                }
            }
        }

        @Override
        public void setLeafCount(ChunkPos pos, byte leafCount) {
            if (leafCount < 0) {
                leafCount = 0;
            }
            this.leaves.put(pos, leafCount);
        }

        @Override
        public byte getLeafCount(ChunkPos pos) {
            return this.leaves.containsKey(pos) ? this.leaves.get(pos) : (byte)-1;
        }

        private void calculatePollutionSpread(List<ChunkPos> pos) {
            ArrayList<ChunkPos> finalPos = new ArrayList<ChunkPos>();
            for (ChunkPos p2 : pos) {
                Chunk chunk = this.world.getChunkProvider().getLoadedChunk(p2.x, p2.z);
                if (chunk == null || !chunk.isLoaded()) continue;
                boolean valid = true;
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        Chunk toCheck;
                        if (x * x == z * z || (toCheck = this.world.getChunkProvider().getLoadedChunk(p2.x + x, p2.z + z)) == null || !toCheck.isLoaded() || !finalPos.contains(toCheck.getPos())) continue;
                        valid = false;
                    }
                }
                if (!valid) continue;
                finalPos.add(p2);
            }
            finalPos.forEach(p -> this.calculatePollutionSpread(this.world, (ChunkPos)p));
        }

        private void calculatePollutionSpread(World world, ChunkPos pos) {
            float pollution = this.getPollution(pos);
            ArrayList<ChunkPos> validChunks = new ArrayList<ChunkPos>();
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    Chunk chunk;
                    if (x * x == z * z || (chunk = world.getChunkProvider().getLoadedChunk(pos.x + x, pos.z + z)) == null || !chunk.isLoaded() || !this.pollution.containsKey(chunk.getPos())) continue;
                    validChunks.add(chunk.getPos());
                }
            }
            if (!validChunks.isEmpty()) {
                for (ChunkPos p : validChunks) {
                    float pollutionCheck = this.getPollution(p);
                    if (pollution == pollutionCheck) continue;
                    if (pollution > pollutionCheck) {
                        this.calculateNewPollution(pos, p);
                        continue;
                    }
                    this.calculateNewPollution(p, pos);
                }
            }
        }

        private void calculateNewPollution(ChunkPos fromChunk, ChunkPos toChunk) {
            float from = this.getPollution(fromChunk);
            float to = this.getPollution(toChunk);
            if (to / from > 0.2f) {
                float change = from * 0.2f;
                from -= change;
                to += change;
            } else {
                float difference = to / from;
                difference = difference == 0.0f ? from / 4.0f : (difference /= 3.0f);
                from -= difference;
                to += difference;
            }
            this.setPollution(fromChunk, from);
            this.setPollution(toChunk, to);
        }

        @Override
        public void readNBT(ChunkPos pos, NBTTagCompound tag) {
            float pollution = 0.0f;
            byte leafCount = 0;
            if (tag.hasKey("pollution")) {
                pollution = tag.getFloat("pollution");
            }
            if (tag.hasKey("leaves")) {
                leafCount = tag.getByte("leaves");
            }
            this.setPollution(pos, pollution);
            this.setLeafCount(pos, leafCount);
        }

        @Override
        public NBTTagCompound writeNBT(ChunkPos pos, NBTTagCompound tag) {
            float pollution = this.getPollution(pos);
            byte leafCount = this.getLeafCount(pos);
            if (pollution < 0.0f) {
                pollution = 0.0f;
            }
            if (leafCount < 0) {
                leafCount = 0;
            }
            tag.setFloat("pollution", pollution);
            tag.setByte("leaves", leafCount);
            return tag;
        }
    }

    public static class Impl
    implements Capability.IStorage<IWorldPollution> {
        public NBTBase writeNBT(Capability<IWorldPollution> capability, IWorldPollution pollution, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<IWorldPollution> capability, IWorldPollution pollution, EnumFacing side, NBTBase nbt) {
        }
    }
}

