/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.strata;

import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.BrokenToolRegistry;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class HCStrata
extends Feature {
    private static final Pattern PATTERN = Pattern.compile("^([\\-]?\\d+)=(\\d{1,255}),(\\d{1,255}).*");
    public static boolean ENABLED;
    public static float[] STRATA_SPEEDS;
    public static float INCORRECT_STRATA_SCALE;
    public static HashMap<IBlockState, BlockType> STATES;
    public static HashMap<Integer, StrataConfig> STRATA_CONFIGS;
    public static StrataConfig DEFAULT;
    public static NoiseGeneratorPerlin STRATA_NOISE1;
    public static NoiseGeneratorPerlin STRATA_NOISE2;

    public HCStrata() {
        this.enabledByDefault = false;
    }

    public static void addStone(IBlockState state) {
        STATES.put(state, BlockType.STONE);
    }

    public static void addStone(Block block) {
        for (IBlockState state : block.getBlockState().getValidStates()) {
            HCStrata.addStone(state);
        }
    }

    public static void addOre(Block block) {
        for (IBlockState state : block.getBlockState().getValidStates()) {
            STATES.put(state, BlockType.ORE);
        }
    }

    public static boolean shouldStratify(World world, BlockPos pos) {
        return HCStrata.shouldStratify(world, world.getBlockState(pos));
    }

    public static boolean shouldStratify(World world, IBlockState state) {
        return STRATA_CONFIGS.containsKey(world.provider.getDimension()) && STATES.keySet().stream().anyMatch(s -> s.equals(state));
    }

    public static Stratification getStratification(World world, BlockPos pos, int dimension) {
        return STRATA_CONFIGS.getOrDefault(dimension, DEFAULT).getStrata(pos.getY() + (int)HCStrata.getNoise(world, pos.getY()).getValue((double)pos.getX(), (double)pos.getZ()));
    }

    private static void loadStrataConfig(String entry) {
        Matcher matcher = PATTERN.matcher(entry);
        if (matcher.matches()) {
            int dim = Integer.parseInt(matcher.group(1));
            int medium = Integer.parseInt(matcher.group(2));
            int hard = Integer.parseInt(matcher.group(3));
            STRATA_CONFIGS.put(dim, new StrataConfig(medium, hard));
        }
    }

    public static NoiseGeneratorPerlin getNoise(World world, int y) {
        if (y < 50) {
            if (STRATA_NOISE2 == null) {
                STRATA_NOISE2 = new NoiseGeneratorPerlin(world.rand, 3);
            }
            return STRATA_NOISE2;
        }
        if (STRATA_NOISE1 == null) {
            STRATA_NOISE1 = new NoiseGeneratorPerlin(world.rand, 2);
        }
        return STRATA_NOISE1;
    }

    @SubscribeEvent
    public void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Random seed = event.player.getEntityWorld().rand;
        STRATA_NOISE1 = new NoiseGeneratorPerlin(seed, 2);
        STRATA_NOISE2 = new NoiseGeneratorPerlin(seed, 3);
    }

    @Override
    public void setupConfig() {
        STRATA_SPEEDS = new float[]{(float)this.loadPropDouble("Light Strata", "Speed for Light Strata", 1.0), (float)this.loadPropDouble("Medium Strata", "Speed for Medium Strata", 1.0), (float)this.loadPropDouble("Dark Strata", "Speed for Dark Strata", 1.0)};
        INCORRECT_STRATA_SCALE = (float)this.loadPropDouble("Incorrect Strata", "Speed scale for when the Strata is higher than the tool", 0.1);
        Arrays.stream(this.loadPropStringList("Strata Configs", "Set the strata levels for a given dimension, <dim>=< medium start y>,<hard start y>", new String[]{"0=42,21"})).map(s -> s.replaceAll(" ", "")).forEach(HCStrata::loadStrataConfig);
    }

    @Override
    public String getFeatureDescription() {
        return "Divides the underground into three strata. Each strata requires the next tool tier to properly mine";
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ENABLED = ModuleLoader.isFeatureEnabled(HCStrata.class);
        for (BWOreDictionary.Ore ore : BWOreDictionary.oreNames) {
            for (ItemStack stack : ore.getOres()) {
                if (!(stack.getItem() instanceof ItemBlock)) continue;
                HCStrata.addOre(((ItemBlock)stack.getItem()).getBlock());
            }
        }
        List<ItemStack> stones = this.loadItemStackList("Strata Stones", "Blocks that are considered as stone to HCStrata", new ItemStack[]{new ItemStack(Blocks.STONE, 1, Short.MAX_VALUE)});
        stones.stream().map(BWMRecipes::getStatesFromStack).flatMap(Collection::stream).forEach(HCStrata::addStone);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getHarvester() == null) {
            return;
        }
        IBlockState state = event.getState();
        if (HCStrata.shouldStratify(world, state)) {
            int level;
            ItemStack stack = BrokenToolRegistry.findItem(event.getHarvester(), event.getState());
            int strata = HCStrata.getStratification(world, pos, world.provider.getDimension()).ordinal();
            if (STATES.getOrDefault(event.getState(), BlockType.STONE) == BlockType.STONE && (level = Math.max(1, stack.getItem().getHarvestLevel(stack, "pickaxe", event.getHarvester(), event.getState()))) <= strata) {
                event.getDrops().clear();
            }
        }
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockPos pos;
        World world = event.getEntityPlayer().getEntityWorld();
        if (HCStrata.shouldStratify(world, pos = event.getPos())) {
            int level;
            ItemStack stack = BrokenToolRegistry.findItem(event.getEntityPlayer(), event.getState());
            float scale = 1.0f;
            int strata = HCStrata.getStratification(world, pos, world.provider.getDimension()).ordinal();
            if (STATES.getOrDefault(event.getState(), BlockType.STONE) == BlockType.STONE && (level = Math.max(1, stack.getItem().getHarvestLevel(stack, "pickaxe", event.getEntityPlayer(), event.getState()))) <= strata) {
                scale = INCORRECT_STRATA_SCALE;
            }
            event.setNewSpeed(scale * STRATA_SPEEDS[strata] * event.getOriginalSpeed());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        STATES = Maps.newHashMap();
        STRATA_CONFIGS = Maps.newHashMap();
        DEFAULT = new StrataConfig(-1, -1);
    }

    private static class StrataConfig {
        private int medium;
        private int hard;

        public StrataConfig(int medium, int hard) {
            this.medium = medium;
            this.hard = hard;
        }

        public Stratification getStrata(int y) {
            return y <= this.hard ? Stratification.HARD : (y <= this.medium ? Stratification.MEDIUM : Stratification.NORMAL);
        }
    }

    public static enum Stratification {
        NORMAL,
        MEDIUM,
        HARD;

    }

    private static enum BlockType {
        STONE(0),
        ORE(1);

        private int level;

        private BlockType(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

