/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.saplings;

import betterwithmods.common.BWMBlocks;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.world.saplings.BlockSaplingCrop;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSapling
extends Feature {
    public static Map<BlockPlanks.EnumType, Block> SAPLING_CROPS = Maps.newHashMap();

    public static IBlockState getSapling(BlockPlanks.EnumType type) {
        return Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)type);
    }

    @Override
    public String getFeatureDescription() {
        return "Change saplings to grow in stages before becoming a tree";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            Block crop = (Block)new BlockSaplingCrop(HCSapling.getSapling(type)).setRegistryName("betterwithmods", String.format("sapling_crop_%s", type.getName()));
            BWMBlocks.registerBlock(crop, null);
            SAPLING_CROPS.put(type, crop);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        IBlockState state;
        BlockPlanks.EnumType type;
        Block crop;
        if (event.getPlayer() != null && event.getPlacedBlock().getBlock() instanceof BlockSapling && (crop = SAPLING_CROPS.get(type = (BlockPlanks.EnumType)(state = event.getPlacedBlock()).getValue((IProperty)BlockSapling.TYPE))) != null && event.getBlockSnapshot().getReplacedBlock().getBlock() == Blocks.AIR) {
            event.getWorld().setBlockState(event.getPos(), crop.getDefaultState());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

