/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockDirtSlab;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HCMovement
extends Feature {
    public static final UUID HCMOVEMENT_SPEED_UUID = UUID.fromString("aece6a05-d163-4871-aaf3-ebab43b0fcfa");
    public static final HashMap<Material, Float> MATERIAL_MOVEMENT = Maps.newHashMap();
    public static final HashMap<IBlockState, Float> BLOCK_OVERRIDE_MOVEMENT = Maps.newHashMap();
    public static final float DEFAULT_SPEED = 0.75f;
    public static final float FAST = 1.2f;
    public static boolean dirtpathQuality;
    public static HashMap<UUID, Float> PREVIOUS_SPEED;

    @Override
    public void setupConfig() {
        dirtpathQuality = this.loadPropBool("Dirt Paths Require Quality Shovel", "Dirt Paths require a shovel greater than stone to be created", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Change walking speed depending on the block";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MATERIAL_MOVEMENT.put(Material.ROCK, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.WOOD, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.IRON, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.CLOTH, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.CARPET, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.CIRCUITS, Float.valueOf(1.2f));
        MATERIAL_MOVEMENT.put(Material.GRASS, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.GLASS, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.GROUND, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.CLAY, Float.valueOf(1.0f));
        MATERIAL_MOVEMENT.put(Material.SAND, Float.valueOf(0.75f));
        MATERIAL_MOVEMENT.put(Material.SNOW, Float.valueOf(0.75f));
        MATERIAL_MOVEMENT.put(Material.LEAVES, Float.valueOf(0.7f));
        MATERIAL_MOVEMENT.put(Material.PLANTS, Float.valueOf(0.7f));
        MATERIAL_MOVEMENT.put(Material.VINE, Float.valueOf(0.7f));
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.SOUL_SAND.getDefaultState(), Float.valueOf(0.7f));
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.GRAVEL.getDefaultState(), Float.valueOf(1.2f));
        BLOCK_OVERRIDE_MOVEMENT.put(Blocks.GRASS_PATH.getDefaultState(), Float.valueOf(1.2f));
        BLOCK_OVERRIDE_MOVEMENT.put(BWMBlocks.DIRT_SLAB.getDefaultState().withProperty(BlockDirtSlab.VARIANT, (Comparable)((Object)BlockDirtSlab.DirtSlabType.PATH)), Float.valueOf(1.2f));
    }

    @SubscribeEvent
    public void onWalk(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayer player = event.player;
            float speed = 0.0f;
            if (player.onGround) {
                BlockPos blockpos = new BlockPos(MathHelper.floor((double)player.posX), MathHelper.floor((double)(player.posY - 0.2)), MathHelper.floor((double)player.posZ));
                IBlockState state = player.world.getBlockState(blockpos);
                speed = BLOCK_OVERRIDE_MOVEMENT.containsKey(state) ? BLOCK_OVERRIDE_MOVEMENT.get(state).floatValue() : MATERIAL_MOVEMENT.getOrDefault(state.getMaterial(), Float.valueOf(0.75f)).floatValue();
                if (!player.world.getBlockState(player.getPosition()).getMaterial().isSolid()) {
                    state = player.world.getBlockState(player.getPosition());
                    if (BLOCK_OVERRIDE_MOVEMENT.containsKey(state)) {
                        speed = BLOCK_OVERRIDE_MOVEMENT.get(state).floatValue();
                    } else if (MATERIAL_MOVEMENT.containsKey(state.getMaterial())) {
                        speed *= MATERIAL_MOVEMENT.get(state.getMaterial()).floatValue();
                    }
                }
                PREVIOUS_SPEED.put(player.getGameProfile().getId(), Float.valueOf(speed));
            }
            if (speed == 0.0f) {
                speed = PREVIOUS_SPEED.getOrDefault(player.getGameProfile().getId(), Float.valueOf(0.75f)).floatValue();
            }
            PlayerHelper.changeSpeed((EntityLivingBase)player, "HCMovement", speed, HCMOVEMENT_SPEED_UUID);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        EntityPlayer player = event.getEntity();
        float f = 1.0f;
        if (player.capabilities.isFlying) {
            f *= 1.1f;
        }
        IAttributeInstance iattributeinstance = player.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        double value = iattributeinstance.getAttributeValue();
        AttributeModifier mod = iattributeinstance.getModifier(HCMOVEMENT_SPEED_UUID);
        if (mod != null) {
            value /= 1.0 + mod.getAmount();
        }
        f = (float)((double)f * ((value / (double)player.capabilities.getWalkSpeed() + 1.0) / 2.0));
        if (player.capabilities.getWalkSpeed() == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        if (player.isHandActive() && player.getActiveItemStack().getItem() == Items.BOW) {
            int i = player.getItemInUseMaxCount();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            f *= 1.0f - f1 * 0.15f;
        }
        event.setNewfov(f);
    }

    static {
        PREVIOUS_SPEED = Maps.newHashMap();
    }
}

