/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import betterwithmods.module.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSheep
extends Feature {
    public static final ResourceLocation NATURAL_COLOR = new ResourceLocation("betterwithmods", "natural_color");
    private static final HashMap<NaturalColorMix, EnumDyeColor> COLOR_MIX_TABLE = new HashMap();
    private static final ArrayList<EnumDyeColor> MUTATION_COLORS = new ArrayList();
    private static int mutationChance = 500;
    @CapabilityInject(value=NaturalColor.class)
    public static Capability<NaturalColor> NATURAL_COLOR_CAP;

    public static void addMutation(EnumDyeColor color) {
        MUTATION_COLORS.add(color);
    }

    public static void addShapedColorMixing(EnumDyeColor colorA, EnumDyeColor colorB, EnumDyeColor result) {
        COLOR_MIX_TABLE.put(new NaturalColorMix(colorA, colorB), result);
    }

    public static void addShapelessColorMixing(EnumDyeColor colorA, EnumDyeColor colorB, EnumDyeColor result) {
        COLOR_MIX_TABLE.put(new NaturalColorMix(colorA, colorB), result);
        COLOR_MIX_TABLE.put(new NaturalColorMix(colorB, colorA), result);
    }

    @Override
    public void setupConfig() {
        mutationChance = this.loadPropInt("Mutation Chance", "How likely a sheep is to mutate into a weird natural color. Chance is 1 in n. Default mirrors vanilla chance to obtain pink sheep.", 500);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        CapabilityManager.INSTANCE.register(NaturalColor.class, (Capability.IStorage)new Capability.IStorage<NaturalColor>(){

            @Nullable
            public NBTBase writeNBT(Capability<NaturalColor> capability, NaturalColor instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<NaturalColor> capability, NaturalColor instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, NaturalColor::new);
        HCSheep.addMutation(EnumDyeColor.BLACK);
        HCSheep.addMutation(EnumDyeColor.LIME);
        HCSheep.addMutation(EnumDyeColor.LIGHT_BLUE);
        HCSheep.addMutation(EnumDyeColor.PINK);
        HCSheep.addShapedColorMixing(EnumDyeColor.BLACK, EnumDyeColor.WHITE, EnumDyeColor.SILVER);
        HCSheep.addShapedColorMixing(EnumDyeColor.WHITE, EnumDyeColor.BLACK, EnumDyeColor.GRAY);
        HCSheep.addShapelessColorMixing(EnumDyeColor.BLACK, EnumDyeColor.SILVER, EnumDyeColor.GRAY);
        HCSheep.addShapelessColorMixing(EnumDyeColor.BLACK, EnumDyeColor.LIGHT_BLUE, EnumDyeColor.BLUE);
        HCSheep.addShapelessColorMixing(EnumDyeColor.BLACK, EnumDyeColor.LIME, EnumDyeColor.GREEN);
        HCSheep.addShapelessColorMixing(EnumDyeColor.BLACK, EnumDyeColor.PINK, EnumDyeColor.RED);
        HCSheep.addShapelessColorMixing(EnumDyeColor.WHITE, EnumDyeColor.GRAY, EnumDyeColor.SILVER);
        HCSheep.addShapelessColorMixing(EnumDyeColor.WHITE, EnumDyeColor.BLUE, EnumDyeColor.LIGHT_BLUE);
        HCSheep.addShapelessColorMixing(EnumDyeColor.WHITE, EnumDyeColor.GREEN, EnumDyeColor.LIME);
        HCSheep.addShapelessColorMixing(EnumDyeColor.WHITE, EnumDyeColor.RED, EnumDyeColor.PINK);
        HCSheep.addShapelessColorMixing(EnumDyeColor.RED, EnumDyeColor.BLUE, EnumDyeColor.PURPLE);
        HCSheep.addShapelessColorMixing(EnumDyeColor.BLUE, EnumDyeColor.GREEN, EnumDyeColor.CYAN);
        HCSheep.addShapelessColorMixing(EnumDyeColor.GREEN, EnumDyeColor.RED, EnumDyeColor.YELLOW);
        HCSheep.addShapelessColorMixing(EnumDyeColor.RED, EnumDyeColor.YELLOW, EnumDyeColor.ORANGE);
        HCSheep.addShapelessColorMixing(EnumDyeColor.PURPLE, EnumDyeColor.WHITE, EnumDyeColor.MAGENTA);
        HCSheep.addShapelessColorMixing(EnumDyeColor.RED, EnumDyeColor.LIGHT_BLUE, EnumDyeColor.MAGENTA);
        HCSheep.addShapelessColorMixing(EnumDyeColor.CYAN, EnumDyeColor.RED, EnumDyeColor.BROWN);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Sheep can mutate, shearing them resets their wool color to their natural color, breeding them can produce all colors";
    }

    @SubscribeEvent
    public void sheepCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntitySheep) {
            event.addCapability(NATURAL_COLOR, (ICapabilityProvider)new NaturalColor());
        }
    }

    @SubscribeEvent
    public void sheepSpawnEvent(LivingSpawnEvent event) {
        if (event instanceof LivingSpawnEvent.AllowDespawn) {
            return;
        }
        World world = event.getEntity().world;
        if (world.isRemote) {
            return;
        }
        if (event.getEntity() instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)event.getEntity();
            this.mutateSheep(sheep, event.getWorld().rand);
            this.setNaturalColor((Entity)sheep, sheep.getFleeceColor());
        }
    }

    private void mutateSheep(EntitySheep sheep, Random random) {
        if (random.nextInt(mutationChance) < 1 && !MUTATION_COLORS.isEmpty()) {
            sheep.setFleeceColor(MUTATION_COLORS.get(random.nextInt(MUTATION_COLORS.size())));
        }
    }

    private EnumDyeColor getNaturalColor(Entity sheep) {
        if (sheep.hasCapability(NATURAL_COLOR_CAP, null)) {
            NaturalColor color = (NaturalColor)sheep.getCapability(NATURAL_COLOR_CAP, null);
            return color.color;
        }
        return EnumDyeColor.WHITE;
    }

    private void setNaturalColor(Entity sheep, EnumDyeColor newcolor) {
        if (sheep.hasCapability(NATURAL_COLOR_CAP, null)) {
            NaturalColor color = (NaturalColor)sheep.getCapability(NATURAL_COLOR_CAP, null);
            color.color = newcolor;
        }
    }

    private EnumDyeColor mixNaturalColors(EnumDyeColor colorA, EnumDyeColor colorB, Random random) {
        NaturalColorMix mix = new NaturalColorMix(colorA, colorB);
        if (COLOR_MIX_TABLE.containsKey(mix)) {
            return COLOR_MIX_TABLE.get(mix);
        }
        return random.nextInt(2) < 1 ? colorA : colorB;
    }

    @SubscribeEvent
    public void sheepBreedEvent(BabyEntitySpawnEvent event) {
        World world = event.getParentA().world;
        if (world.isRemote) {
            return;
        }
        if (event.getParentA() instanceof EntitySheep && event.getParentB() instanceof EntitySheep && event.getChild() instanceof EntitySheep) {
            EntitySheep father = (EntitySheep)event.getParentA();
            EntitySheep mother = (EntitySheep)event.getParentB();
            EntitySheep child = (EntitySheep)event.getChild();
            child.setFleeceColor(this.mixNaturalColors(this.getNaturalColor((Entity)father), this.getNaturalColor((Entity)mother), world.rand));
            this.mutateSheep(child, world.rand);
            this.setNaturalColor((Entity)child, child.getFleeceColor());
        }
    }

    @SubscribeEvent
    public void sheepUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (!entity.world.isRemote && entity instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)entity;
            if (!sheep.getSheared()) {
                return;
            }
            NaturalColor cap = (NaturalColor)sheep.getCapability(NATURAL_COLOR_CAP, null);
            if (cap != null) {
                EnumDyeColor naturalColor = cap.color;
                if (sheep.getFleeceColor() != naturalColor) {
                    sheep.setFleeceColor(naturalColor);
                }
            }
        }
    }

    public static class NaturalColor
    implements ICapabilitySerializable<NBTTagCompound> {
        public EnumDyeColor color = EnumDyeColor.WHITE;

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == NATURAL_COLOR_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == NATURAL_COLOR_CAP) {
                return (T)NATURAL_COLOR_CAP.cast((Object)this);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.setInteger("NaturalColor", this.color.getMetadata());
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.color = EnumDyeColor.byMetadata((int)nbt.getInteger("NaturalColor"));
        }
    }

    private static class NaturalColorMix {
        EnumDyeColor colorA;
        EnumDyeColor colorB;

        public NaturalColorMix(EnumDyeColor colorA, EnumDyeColor colorB) {
            this.colorA = colorA;
            this.colorB = colorB;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NaturalColorMix) {
                return ((NaturalColorMix)obj).colorA.equals((Object)this.colorA) && ((NaturalColorMix)obj).colorB.equals((Object)this.colorB);
            }
            return false;
        }

        public int hashCode() {
            return this.colorA.getMetadata() | this.colorB.getMetadata() << 4;
        }
    }
}

