/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import betterwithmods.bwl.event.EntitySetEquipmentEvent;
import betterwithmods.module.CompatFeature;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCMobEquipment
extends CompatFeature {
    public static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public static final ItemStack[] IRON_ARMOR = new ItemStack[]{new ItemStack((Item)Items.IRON_HELMET), new ItemStack((Item)Items.IRON_CHESTPLATE), new ItemStack((Item)Items.IRON_LEGGINGS), new ItemStack((Item)Items.IRON_BOOTS)};
    public static final ItemStack[] GOLD_ARMOR = new ItemStack[]{new ItemStack((Item)Items.GOLDEN_HELMET), new ItemStack((Item)Items.GOLDEN_CHESTPLATE), new ItemStack((Item)Items.GOLDEN_LEGGINGS), new ItemStack((Item)Items.GOLDEN_BOOTS)};
    private static Map<ResourceLocation, Equipment> entityMap = Maps.newHashMap();

    public HCMobEquipment() {
        super("betterwithlib");
        this.enabledByDefault = false;
    }

    private static void pigman(EntityLivingBase entity) {
        if (entity.getRNG().nextFloat() < 0.05f) {
            entity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
        }
        HCMobEquipment.armor(entity, GOLD_ARMOR);
    }

    private static void skeleton(EntityLivingBase entity) {
        entity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.BOW));
    }

    private static void zombie(EntityLivingBase entity) {
        HCMobEquipment.armor(entity, IRON_ARMOR);
        if (entity.getRNG().nextFloat() < 0.05f) {
            int i = entity.getRNG().nextInt(3);
            if (i == 0) {
                entity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SWORD).copy());
            } else {
                entity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SHOVEL).copy());
            }
        }
    }

    private static void armor(EntityLivingBase entity, ItemStack[] armor) {
        if ((double)entity.getRNG().nextFloat() < 0.018) {
            boolean flag = true;
            for (int s = 0; s < ARMOR_SLOTS.length; ++s) {
                EntityEquipmentSlot slot = ARMOR_SLOTS[s];
                ItemStack current = entity.getItemStackFromSlot(slot);
                if (!current.isEmpty() || !flag && (double)entity.getRNG().nextFloat() < 0.1) continue;
                flag = false;
                entity.setItemStackToSlot(slot, armor[s].copy());
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.addEquipmentOverride(new ResourceLocation("minecraft:zombie"), HCMobEquipment::zombie);
        this.addEquipmentOverride(new ResourceLocation("minecraft:husk"), HCMobEquipment::zombie);
        this.addEquipmentOverride(new ResourceLocation("minecraft:skeleton"), HCMobEquipment::skeleton);
        this.addEquipmentOverride(new ResourceLocation("minecraft:zombie_pigman"), HCMobEquipment::pigman);
    }

    public void addEquipmentOverride(ResourceLocation mob, Equipment equipment) {
        if (this.loadPropBool("Override Equipment for " + mob.toString(), "", true)) {
            entityMap.put(mob, equipment);
        }
    }

    @SubscribeEvent
    public void onSetEquipment(EntitySetEquipmentEvent event) {
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        ResourceLocation key = EntityList.getKey((Entity)entity);
        Equipment equipment = entityMap.get(key);
        if (equipment != null) {
            event.setCanceled(true);
            equipment.equip(entity);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Change the equipment that mobs spawn with";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @FunctionalInterface
    private static interface Equipment {
        public void equip(EntityLivingBase var1);
    }
}

