/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.module.Feature;
import betterwithmods.util.InfernalEnchantment;
import betterwithmods.util.WorldUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCEnchanting
extends Feature {
    private static final HashMap<Class<? extends EntityLivingBase>, ScrollDrop> SCROLL_DROPS = Maps.newHashMap();
    private static double dropChance;
    private static double lootingDropBonus;
    private static boolean fuckMending;
    private static boolean steelRequiresInfernal;

    public static boolean canEnchantSteel(Enchantment enchantment) {
        return !steelRequiresInfernal || enchantment instanceof InfernalEnchantment;
    }

    public static void addScrollDrop(Class<? extends EntityLivingBase> clazz, Enchantment enchantment) {
        HCEnchanting.addScrollDrop(clazz, (EntityLivingBase entity) -> ItemArcaneScroll.getScrollWithEnchant(enchantment));
    }

    public static void addScrollDrop(Class<? extends EntityLivingBase> clazz, ItemStack scroll) {
        HCEnchanting.addScrollDrop(clazz, (EntityLivingBase entity) -> scroll);
    }

    public static void addScrollDrop(Class<? extends EntityLivingBase> clazz, ScrollDrop scroll) {
        SCROLL_DROPS.put(clazz, scroll);
    }

    @Override
    public void setupConfig() {
        steelRequiresInfernal = this.loadPropBool("Steel Requires Infernal Enchanter", "Soulforged Steel tools can only be enchanted with the Infernal Enchanter", true);
        dropChance = this.loadPropDouble("Arcane Scroll Drop Chance", "Percentage chance that an arcane scroll will drop, does not effect some scrolls.", 0.001);
        lootingDropBonus = this.loadPropDouble("Arcane Scroll Looting Bonus Multiplier", "Increase the chance of getting a scroll with looting enchants baseChance * ( lootingDropBonus * lootingLevel)", 0.1);
        fuckMending = this.loadPropBool("Disable Mending", "Mending is a bad unbalanced pile of poo", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Adds Arcane Scroll drops to specific mobs, used for enchanting with the Infernal Enchanter";
    }

    @Override
    public void init(FMLInitializationEvent event) {
        HCEnchanting.addScrollDrop(EntitySlime.class, Enchantments.PROTECTION);
        HCEnchanting.addScrollDrop(EntityPigZombie.class, Enchantments.FIRE_PROTECTION);
        HCEnchanting.addScrollDrop(EntityBat.class, Enchantments.FEATHER_FALLING);
        HCEnchanting.addScrollDrop(EntityCreeper.class, Enchantments.BLAST_PROTECTION);
        HCEnchanting.addScrollDrop(AbstractSkeleton.class, (EntityLivingBase entity) -> {
            if (entity.world.provider.getDimensionType() == DimensionType.NETHER) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.INFINITY);
            }
            return ItemArcaneScroll.getScrollWithEnchant(Enchantments.PROJECTILE_PROTECTION);
        });
        HCEnchanting.addScrollDrop(EntitySquid.class, Enchantments.RESPIRATION);
        HCEnchanting.addScrollDrop(EntityWitch.class, Enchantments.AQUA_AFFINITY);
        HCEnchanting.addScrollDrop(EntityZombie.class, Enchantments.SMITE);
        HCEnchanting.addScrollDrop(EntitySpider.class, Enchantments.BANE_OF_ARTHROPODS);
        HCEnchanting.addScrollDrop(EntityMagmaCube.class, Enchantments.FIRE_ASPECT);
        HCEnchanting.addScrollDrop(EntityEnderman.class, Enchantments.SILK_TOUCH);
        HCEnchanting.addScrollDrop(EntityGhast.class, Enchantments.PUNCH);
        HCEnchanting.addScrollDrop(EntityBlaze.class, Enchantments.FLAME);
        HCEnchanting.addScrollDrop(EntityPolarBear.class, Enchantments.FROST_WALKER);
        HCEnchanting.addScrollDrop(EntityGuardian.class, Enchantments.DEPTH_STRIDER);
        if (!fuckMending) {
            HCEnchanting.addScrollDrop(EntityShulker.class, new ScrollDrop(){

                @Override
                public ItemStack getScroll(EntityLivingBase entity) {
                    return ItemArcaneScroll.getScrollWithEnchant(Enchantments.MENDING);
                }

                @Override
                public double getChance() {
                    return 0.001;
                }
            });
        }
        HCEnchanting.addScrollDrop(EntityDragon.class, new ScrollDrop(){

            @Override
            public ItemStack getScroll(EntityLivingBase entity) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.SWEEPING);
            }

            @Override
            public double getChance() {
                return 1.0;
            }
        });
        HCEnchanting.addScrollDrop(EntityWither.class, new ScrollDrop(){

            @Override
            public ItemStack getScroll(EntityLivingBase entity) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.KNOCKBACK);
            }

            @Override
            public double getChance() {
                return 1.0;
            }
        });
        HCEnchanting.addScrollDrop(EntitySilverfish.class, (EntityLivingBase entity) -> {
            if (entity.world.provider.getDimensionType() == DimensionType.THE_END) {
                return ItemArcaneScroll.getScrollWithEnchant(Enchantments.EFFICIENCY);
            }
            return null;
        });
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onDeath(LivingDropsEvent event) {
        for (Class<? extends EntityLivingBase> entity : SCROLL_DROPS.keySet()) {
            double chance;
            ScrollDrop drop;
            if (!entity.isAssignableFrom(event.getEntityLiving().getClass()) || (drop = SCROLL_DROPS.get(entity)).getScroll(event.getEntityLiving()) == null || !((chance = event.getEntityLiving().getRNG().nextDouble() + lootingDropBonus * (double)event.getLootingLevel()) <= drop.getChance())) continue;
            WorldUtils.addDrop(event, drop.getScroll(event.getEntityLiving()));
        }
    }

    @FunctionalInterface
    public static interface ScrollDrop {
        public ItemStack getScroll(EntityLivingBase var1);

        default public double getChance() {
            return dropChance;
        }
    }
}

