/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTentacle
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.createKey(EntityFishHook.class, (DataSerializer)DataSerializers.VARINT);
    private boolean inGround;
    private int ticksInGround;
    private EntityLivingBase angler;
    private int ticksInAir;
    public Entity caughtEntity;
    private State currentState = State.FLYING;

    public EntityTentacle(World world) {
        this(world, null);
    }

    public EntityTentacle(World worldIn, EntityLivingBase angler) {
        super(worldIn);
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
        this.angler = angler;
        this.shoot();
    }

    private void shoot() {
        if (this.angler == null) {
            return;
        }
        float f = this.angler.prevRotationPitch + (this.angler.rotationPitch - this.angler.prevRotationPitch);
        float f1 = this.angler.prevRotationYaw + (this.angler.rotationYaw - this.angler.prevRotationYaw);
        float f2 = MathHelper.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.sin((float)(-f * ((float)Math.PI / 180)));
        double anglerX = this.angler.prevPosX + (this.angler.posX - this.angler.prevPosX);
        double anglerY = this.angler.posY + (this.angler.posY - this.angler.prevPosY) + (double)this.angler.getEyeHeight() * 2.0;
        double anglerZ = this.angler.prevPosZ + (this.angler.posZ - this.angler.prevPosZ);
        this.setLocationAndAngles(anglerX, anglerY, anglerZ, f1, f);
        this.motionX = -f3;
        this.motionY = MathHelper.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f);
        this.motionZ = -f2;
        float f6 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        this.motionX *= 0.6 / (double)f6 + 0.5 + this.rand.nextGaussian() * 0.0045;
        this.motionY *= 0.6 / (double)f6 + 0.5 + this.rand.nextGaussian() * 0.0045;
        this.motionZ *= 0.6 / (double)f6 + 0.5 + this.rand.nextGaussian() * 0.0045;
        float f7 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(MathHelper.atan2((double)this.motionX, (double)this.motionZ) * 57.29577951308232);
        this.rotationPitch = (float)(MathHelper.atan2((double)this.motionY, (double)f7) * 57.29577951308232);
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    protected void entityInit() {
        this.getDataManager().register(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void notifyDataManagerChange(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.getDataManager().get(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.world.getEntityByID(i - 1) : null;
        }
        super.notifyDataManagerChange(key);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double distance) {
        return distance < 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotationDirect(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.angler == null || !this.angler.isEntityAlive()) {
            this.setDead();
        } else if (this.world.isRemote || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.setDead();
                    return;
                }
            }
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.motionX = 0.0;
                    this.motionY = 0.0;
                    this.motionZ = 0.0;
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (!this.world.isRemote) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.onGround || this.collidedHorizontally)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.motionX = 0.0;
                    this.motionY = 0.0;
                    this.motionZ = 0.0;
                }
            } else if (this.currentState == State.HOOKED_IN_ENTITY) {
                if (this.caughtEntity != null) {
                    if (this.caughtEntity.isDead) {
                        this.caughtEntity = null;
                        this.currentState = State.FLYING;
                    } else {
                        this.posX = this.caughtEntity.posX;
                        double d2 = this.caughtEntity.height;
                        this.posY = this.caughtEntity.getEntityBoundingBox().minY + d2 * 0.8;
                        this.posZ = this.caughtEntity.posZ;
                        this.setPosition(this.posX, this.posY, this.posZ);
                    }
                }
                return;
            }
            this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
            this.updateRotation();
            this.motionX *= 0.92;
            this.motionY *= 0.92;
            this.motionZ *= 0.92;
            this.setPosition(this.posX, this.posY, this.posZ);
        }
    }

    private boolean shouldStopFishing() {
        return !this.angler.isEntityAlive();
    }

    private void updateRotation() {
        float f = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(MathHelper.atan2((double)this.motionX, (double)this.motionZ) * 57.29577951308232);
        this.rotationPitch = (float)(MathHelper.atan2((double)this.motionY, (double)f) * 57.29577951308232);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.posX, this.posY, this.posZ);
        Vec3d vec3d1 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        RayTraceResult raytraceresult = this.world.rayTraceBlocks(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.posX, this.posY, this.posZ);
        vec3d1 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.hitVec.x, raytraceresult.hitVec.y, raytraceresult.hitVec.z);
        }
        Entity entity = null;
        List list = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox().expand(this.motionX, this.motionY, this.motionZ).grow(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!this.canBeHooked(entity1) || entity1 == this.angler && this.ticksInAir < 5 || (raytraceresult1 = (axisalignedbb = entity1.getEntityBoundingBox().grow((double)0.3f)).calculateIntercept(vec3d, vec3d1)) == null || !((d1 = vec3d.squareDistanceTo(raytraceresult1.hitVec)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.typeOfHit != RayTraceResult.Type.MISS) {
            if (raytraceresult.typeOfHit == RayTraceResult.Type.ENTITY) {
                this.caughtEntity = raytraceresult.entityHit;
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.getDataManager().set(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.getEntityId() + 1));
    }

    protected boolean canBeHooked(Entity entity) {
        return entity.canBeCollidedWith();
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
    }

    public int handleHookRetraction() {
        if (!this.world.isRemote && this.angler != null) {
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                this.world.setEntityState((Entity)this, (byte)31);
            }
            this.setDead();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        if (id == 31 && this.world.isRemote && this.caughtEntity instanceof EntityPlayer && ((EntityPlayer)this.caughtEntity).isUser()) {
            this.bringInHookedEntity();
        }
        super.handleStatusUpdate(id);
    }

    protected void bringInHookedEntity() {
        if (this.angler != null && this.caughtEntity != null) {
            double d0 = this.angler.posX - this.posX;
            double d1 = this.angler.posY - this.posY;
            double d2 = this.angler.posZ - this.posZ;
            double d3 = 0.5;
            this.caughtEntity.motionX += d0 * d3;
            this.caughtEntity.motionY += d1 * d3;
            this.caughtEntity.motionZ += d2 * d3;
        }
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public void setDead() {
        super.setDead();
    }

    public EntityLivingBase getAngler() {
        return this.angler;
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.angler != null) {
            buffer.writeInt(this.angler.getEntityId());
        } else {
            buffer.writeInt(0);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.angler = (EntityLivingBase)Minecraft.getMinecraft().world.getEntityByID(additionalData.readInt());
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY;

    }
}

