/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.crafting;

import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import betterwithmods.module.Feature;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class HCOres
extends Feature {
    private static boolean oreNuggetSmelting;
    private static boolean dustNuggetSmelting;
    private static boolean fixVanillaRecipes;
    private static Set<String> oreExclude;
    private static Set<String> dustExclude;
    private static int oreProductionCount;
    private static int dustProductionCount;

    @Override
    public void setupConfig() {
        oreNuggetSmelting = this.loadPropBool("Ore to Nugget Smelting", "Make Ores (oredict ore.* )smelt into nuggets instead of ingots", true);
        oreExclude = Arrays.stream(this.loadPropStringList("Ore Exclude", "Oredictionary entries to exclude from ore to nugget smelting. Remove the prefix of the oredictionary. example 'oreIron' would be just 'iron' ", new String[0])).collect(Collectors.toSet());
        dustExclude = Arrays.stream(this.loadPropStringList("Dust Exclude", "Oredictionary entries to exclude from dust to nugget smelting  Remove the prefix of the oredictionary. example 'dustIron' would be just 'iron'", new String[0])).collect(Collectors.toSet());
        dustNuggetSmelting = this.loadPropBool("Dust to Nugget Smelting", "Make Dusts ( oredict dust.* ) smelt into nuggets instead of ingots", true);
        fixVanillaRecipes = this.loadPropBool("Fix Vanilla Recipes", "Make certain recipes cheaper to be more reasonable with nugget smelting, including Compass, Clock, and Bucket", true);
        oreProductionCount = this.loadPropInt("Ore Production Count", "Number of Materials returned from Smelting an Ore", 1);
        dustProductionCount = this.loadPropInt("Dust Production Count", "Number of Materials returned from Smelting a Dust", 1);
    }

    @Override
    public String getFeatureDescription() {
        return "Makes Ores only smelt into a single nugget, making it much harder to create large amounts of metal";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (fixVanillaRecipes) {
            this.addHardcoreRecipe((IRecipe)new ShapedOreRecipe(null, Items.COMPASS, new Object[]{" N ", "NRN", " N ", Character.valueOf('N'), "nuggetIron", Character.valueOf('R'), "dustRedstone"}).setRegistryName(new ResourceLocation("minecraft", "compass")));
            this.addHardcoreRecipe((IRecipe)new ShapedOreRecipe(null, Items.CLOCK, new Object[]{" N ", "NQN", " N ", Character.valueOf('N'), "nuggetGold", Character.valueOf('Q'), "gemQuartz"}).setRegistryName(new ResourceLocation("minecraft", "clock")));
            this.addHardcoreRecipe((IRecipe)new ShapedOreRecipe(null, Items.BUCKET, new Object[]{"N N", "N N", "NNN", Character.valueOf('N'), "nuggetIron"}).setRegistryName(new ResourceLocation("minecraft", "bucket")));
            this.addHardcoreRecipe((IRecipe)new ShapelessOreRecipe(null, Items.FLINT_AND_STEEL, new Object[]{Items.FLINT, "nuggetIron"}).setRegistryName(new ResourceLocation("minecraft", "flint_and_steel")));
        }
        this.addMeltingRecipeWithoutReturn(new ItemStack(Items.BUCKET), new ItemStack(Items.IRON_NUGGET, 7));
        this.addMeltingRecipeWithoutReturn(new ItemStack(Items.WATER_BUCKET), new ItemStack(Items.IRON_NUGGET, 7));
        this.addMeltingRecipeWithoutReturn(new ItemStack(Items.MILK_BUCKET), new ItemStack(Items.IRON_NUGGET, 7));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Item)Items.MAP), new ItemStack(Items.IRON_NUGGET, 4));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.COMPASS), new ItemStack(Items.IRON_NUGGET, 4));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Block)Blocks.TRIPWIRE_HOOK, 2), new ItemStack(Items.IRON_NUGGET));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.CLOCK), new ItemStack(Items.GOLD_NUGGET, 4));
    }

    private void addMeltingRecipeWithoutReturn(ItemStack input, ItemStack output) {
        BWRegistry.CRUCIBLE.addRecipe(new CookingPotRecipe(Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(input)}), Lists.newArrayList((Object[])new ItemStack[]{output}), 2){

            @Override
            protected boolean consumeIngredients(ItemStackHandler inventory, NonNullList<ItemStack> containItems) {
                boolean success = super.consumeIngredients(inventory, containItems);
                containItems.clear();
                return success;
            }
        });
    }

    @Override
    public void disabledInit(FMLInitializationEvent event) {
        this.addMeltingRecipeWithoutReturn(new ItemStack(Items.BUCKET), new ItemStack(Items.IRON_INGOT, 3));
        this.addMeltingRecipeWithoutReturn(new ItemStack(Items.WATER_BUCKET), new ItemStack(Items.IRON_INGOT, 3));
        this.addMeltingRecipeWithoutReturn(new ItemStack(Items.MILK_BUCKET), new ItemStack(Items.IRON_INGOT, 3));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Item)Items.MAP), new ItemStack(Items.IRON_INGOT, 4));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.COMPASS), new ItemStack(Items.IRON_INGOT, 4));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Block)Blocks.TRIPWIRE_HOOK, 2), new ItemStack(Items.IRON_INGOT));
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.CLOCK), new ItemStack(Items.GOLD_INGOT, 4));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        Sets.SetView oreExcludes = Sets.union(oreExclude, (Set)Sets.newHashSet((Object[])new String[]{"oreDiamond"}));
        if (oreNuggetSmelting) {
            for (BWOreDictionary.Ore ore : BWOreDictionary.oreNames) {
                this.replaceRecipe((Set<String>)oreExcludes, ore, oreProductionCount);
            }
        }
        Sets.SetView dustExcludes = Sets.union(dustExclude, (Set)Sets.newHashSet((Object[])new String[]{"dustDiamond"}));
        if (dustNuggetSmelting) {
            for (BWOreDictionary.Ore dust : BWOreDictionary.dustNames) {
                this.replaceRecipe((Set<String>)dustExcludes, dust, dustProductionCount);
            }
        }
    }

    private void replaceRecipe(Set<String> oreExcludes, BWOreDictionary.Ore ore, int oreProductionCount) {
        Optional optionalNugget;
        if (!oreExcludes.contains(ore.getOre()) && (optionalNugget = BWOreDictionary.nuggetNames.stream().filter(o -> o.getSuffix().equals(ore.getSuffix())).flatMap(o -> o.getOres().stream()).findFirst()).isPresent()) {
            for (ItemStack oreStack : ore.getOres()) {
                if (!BWMRecipes.removeFurnaceRecipe(oreStack)) continue;
                ItemStack nugget = ((ItemStack)optionalNugget.get()).copy();
                nugget.setCount(oreProductionCount);
                BWMRecipes.addFurnaceRecipe(oreStack, nugget);
            }
        }
    }
}

