/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.crafting;

import betterwithmods.common.BWMItems;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.Feature;
import betterwithmods.util.ReflectionLib;
import betterwithmods.util.StackIngredient;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HCBrewing
extends Feature {
    private static boolean removeMovementPotions;
    private static boolean waterBreathingAnyFish;
    private static boolean removeWitchPotionDrops;
    private static boolean modPotionCompat;
    private static int potionStackSize;
    private boolean tryChangePotions;

    @Override
    public void setupConfig() {
        removeMovementPotions = this.loadPropBool("Remove Movement Potions", "Removes recipes for Speed and Leaping potions.", true);
        waterBreathingAnyFish = this.loadPropBool("Water Breathing Any Fish", "Any fish works for brewing Water Breathing potions.", true);
        removeWitchPotionDrops = this.loadPropBool("Remove Witch Ingredient Drops", "Removes redstone and glowstone from witch drops", true);
        modPotionCompat = this.loadPropBool("Modded Potion Compatibility", "Similarly modifies non-vanilla potions.", true);
        potionStackSize = this.loadPropInt("Potion Stacksize", "Maximum stacksize of potion items.", 8);
    }

    @Override
    public String getFeatureDescription() {
        return "Modifies and rebalances vanilla brewing recipes and makes potions stack up to 8.";
    }

    private boolean isWitchDropBlacklisted(ItemStack stack) {
        Item item = stack.getItem();
        return item == Items.GLOWSTONE_DUST || item == Items.SUGAR || item == Items.SPIDER_EYE || item == Items.GUNPOWDER;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void mobDrops(LivingDropsEvent evt) {
        EntityLivingBase entity = evt.getEntityLiving();
        List drops = evt.getDrops();
        if (entity instanceof EntityWitch) {
            Iterator iterator = drops.iterator();
            while (iterator.hasNext()) {
                EntityItem item = (EntityItem)iterator.next();
                ItemStack stack = item.getItem();
                if (removeWitchPotionDrops && this.isWitchDropBlacklisted(stack)) {
                    iterator.remove();
                    continue;
                }
                if (stack.getItem() != Items.REDSTONE) continue;
                item.setItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART, stack.getCount()));
            }
        }
        if (entity instanceof EntitySquid && entity.world.rand.nextInt(100) < 10) {
            entity.entityDropItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.MYSTERY_GLAND), 0.0f);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.tryChangePotions = true;
        List mixPredicates = (List)ReflectionHelper.getPrivateValue(PotionHelper.class, null, (String[])ReflectionLib.POTIONHELPER_TYPE_CONVERSIONS);
        List mixItemPredicates = (List)ReflectionHelper.getPrivateValue(PotionHelper.class, null, (String[])ReflectionLib.POTIONHELPER_ITEM_CONVERSIONS);
        List moddedPotions = mixPredicates.stream().filter(this::isModdedPotion).collect(Collectors.toList());
        mixPredicates.clear();
        mixItemPredicates.clear();
        Items.POTIONITEM.setMaxStackSize(potionStackSize);
        Items.SPLASH_POTION.setMaxStackSize(potionStackSize);
        Items.LINGERING_POTION.setMaxStackSize(potionStackSize);
        if (this.tryChangePotions) {
            Ingredient extender = this.convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART));
            Ingredient strenthener = this.convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE));
            Ingredient inverter = this.convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POISON_SAC));
            Ingredient awkward = this.convertToPotionItem(Items.NETHER_WART);
            Ingredient fireResistance = this.convertToPotionItem(Items.MAGMA_CREAM);
            Ingredient nightVision = this.convertToPotionItem(Items.SPIDER_EYE);
            Ingredient poison = this.convertToPotionItem((Block)Blocks.RED_MUSHROOM);
            Ingredient regeneration = this.convertToPotionItem(Items.GHAST_TEAR);
            Ingredient strength = this.convertToPotionItem(Items.BLAZE_POWDER);
            Ingredient swiftness = this.convertToPotionItem(Items.SUGAR);
            Ingredient leaping = this.convertToPotionItem(Items.RABBIT_FOOT);
            Ingredient waterBreathing = this.convertToPotionItem(new ItemStack(Items.FISH, ItemFishFood.FishType.PUFFERFISH.getMetadata()));
            if (waterBreathingAnyFish) {
                waterBreathing = this.convertToPotionItem(Items.FISH);
            }
            Ingredient healing = this.convertToPotionItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.MYSTERY_GLAND));
            PotionHelper.addContainerRecipe((ItemPotion)Items.POTIONITEM, (Item)BWMItems.CREEPER_OYSTER, (ItemPotion)Items.SPLASH_POTION);
            PotionHelper.addContainerRecipe((ItemPotion)Items.SPLASH_POTION, (Item)Items.DRAGON_BREATH, (ItemPotion)Items.LINGERING_POTION);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)awkward, (PotionType)PotionTypes.AWKWARD);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)extender, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)strenthener, (PotionType)PotionTypes.THICK);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)fireResistance, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)nightVision, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)poison, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)regeneration, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)strength, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)swiftness, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)leaping, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)waterBreathing, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)healing, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.WATER, (Ingredient)inverter, (PotionType)PotionTypes.MUNDANE);
            PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)fireResistance, (PotionType)PotionTypes.FIRE_RESISTANCE);
            PotionHelper.addMix((PotionType)PotionTypes.FIRE_RESISTANCE, (Ingredient)extender, (PotionType)PotionTypes.LONG_FIRE_RESISTANCE);
            PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)nightVision, (PotionType)PotionTypes.NIGHT_VISION);
            PotionHelper.addMix((PotionType)PotionTypes.NIGHT_VISION, (Ingredient)extender, (PotionType)PotionTypes.LONG_NIGHT_VISION);
            PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)poison, (PotionType)PotionTypes.POISON);
            PotionHelper.addMix((PotionType)PotionTypes.POISON, (Ingredient)strenthener, (PotionType)PotionTypes.STRONG_POISON);
            PotionHelper.addMix((PotionType)PotionTypes.POISON, (Ingredient)extender, (PotionType)PotionTypes.LONG_POISON);
            PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)regeneration, (PotionType)PotionTypes.REGENERATION);
            PotionHelper.addMix((PotionType)PotionTypes.REGENERATION, (Ingredient)extender, (PotionType)PotionTypes.LONG_REGENERATION);
            PotionHelper.addMix((PotionType)PotionTypes.REGENERATION, (Ingredient)strenthener, (PotionType)PotionTypes.STRONG_REGENERATION);
            PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)strength, (PotionType)PotionTypes.STRENGTH);
            PotionHelper.addMix((PotionType)PotionTypes.STRENGTH, (Ingredient)strenthener, (PotionType)PotionTypes.STRONG_STRENGTH);
            PotionHelper.addMix((PotionType)PotionTypes.STRENGTH, (Ingredient)extender, (PotionType)PotionTypes.LONG_STRENGTH);
            if (!removeMovementPotions) {
                PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)swiftness, (PotionType)PotionTypes.SWIFTNESS);
                PotionHelper.addMix((PotionType)PotionTypes.SWIFTNESS, (Ingredient)strenthener, (PotionType)PotionTypes.STRONG_SWIFTNESS);
                PotionHelper.addMix((PotionType)PotionTypes.SWIFTNESS, (Ingredient)extender, (PotionType)PotionTypes.LONG_SWIFTNESS);
                PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)leaping, (PotionType)PotionTypes.LEAPING);
                PotionHelper.addMix((PotionType)PotionTypes.LEAPING, (Ingredient)extender, (PotionType)PotionTypes.LONG_LEAPING);
                PotionHelper.addMix((PotionType)PotionTypes.LEAPING, (Ingredient)strenthener, (PotionType)PotionTypes.STRONG_LEAPING);
                PotionHelper.addMix((PotionType)PotionTypes.SWIFTNESS, (Ingredient)inverter, (PotionType)PotionTypes.SLOWNESS);
                PotionHelper.addMix((PotionType)PotionTypes.STRONG_SWIFTNESS, (Ingredient)inverter, (PotionType)PotionTypes.SLOWNESS);
                PotionHelper.addMix((PotionType)PotionTypes.LONG_SWIFTNESS, (Ingredient)inverter, (PotionType)PotionTypes.LONG_SLOWNESS);
                PotionHelper.addMix((PotionType)PotionTypes.LEAPING, (Ingredient)inverter, (PotionType)PotionTypes.SLOWNESS);
                PotionHelper.addMix((PotionType)PotionTypes.STRONG_LEAPING, (Ingredient)inverter, (PotionType)PotionTypes.SLOWNESS);
                PotionHelper.addMix((PotionType)PotionTypes.LONG_LEAPING, (Ingredient)inverter, (PotionType)PotionTypes.LONG_SLOWNESS);
                PotionHelper.addMix((PotionType)PotionTypes.SLOWNESS, (Ingredient)extender, (PotionType)PotionTypes.LONG_SLOWNESS);
            }
            PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)waterBreathing, (PotionType)PotionTypes.WATER_BREATHING);
            PotionHelper.addMix((PotionType)PotionTypes.WATER_BREATHING, (Ingredient)extender, (PotionType)PotionTypes.LONG_WATER_BREATHING);
            PotionHelper.addMix((PotionType)PotionTypes.AWKWARD, (Ingredient)healing, (PotionType)PotionTypes.HEALING);
            PotionHelper.addMix((PotionType)PotionTypes.HEALING, (Ingredient)strenthener, (PotionType)PotionTypes.STRONG_HEALING);
            PotionHelper.addMix((PotionType)PotionTypes.HEALING, (Ingredient)inverter, (PotionType)PotionTypes.HARMING);
            PotionHelper.addMix((PotionType)PotionTypes.STRONG_HEALING, (Ingredient)inverter, (PotionType)PotionTypes.STRONG_HARMING);
            PotionHelper.addMix((PotionType)PotionTypes.POISON, (Ingredient)inverter, (PotionType)PotionTypes.HARMING);
            PotionHelper.addMix((PotionType)PotionTypes.LONG_POISON, (Ingredient)inverter, (PotionType)PotionTypes.HARMING);
            PotionHelper.addMix((PotionType)PotionTypes.STRONG_POISON, (Ingredient)inverter, (PotionType)PotionTypes.STRONG_HARMING);
            PotionHelper.addMix((PotionType)PotionTypes.HARMING, (Ingredient)strenthener, (PotionType)PotionTypes.STRONG_HARMING);
            PotionHelper.addMix((PotionType)PotionTypes.STRENGTH, (Ingredient)inverter, (PotionType)PotionTypes.WEAKNESS);
            PotionHelper.addMix((PotionType)PotionTypes.STRONG_STRENGTH, (Ingredient)inverter, (PotionType)PotionTypes.WEAKNESS);
            PotionHelper.addMix((PotionType)PotionTypes.LONG_STRENGTH, (Ingredient)inverter, (PotionType)PotionTypes.LONG_WEAKNESS);
            PotionHelper.addMix((PotionType)PotionTypes.WEAKNESS, (Ingredient)extender, (PotionType)PotionTypes.LONG_WEAKNESS);
            PotionHelper.addMix((PotionType)PotionTypes.NIGHT_VISION, (Ingredient)inverter, (PotionType)PotionTypes.INVISIBILITY);
            PotionHelper.addMix((PotionType)PotionTypes.LONG_NIGHT_VISION, (Ingredient)inverter, (PotionType)PotionTypes.LONG_INVISIBILITY);
            PotionHelper.addMix((PotionType)PotionTypes.INVISIBILITY, (Ingredient)extender, (PotionType)PotionTypes.LONG_INVISIBILITY);
            if (modPotionCompat) {
                ItemStack extenderToReplace = new ItemStack(Items.REDSTONE);
                ItemStack strengthenerToReplace = new ItemStack(Items.GLOWSTONE_DUST);
                ItemStack inverterToReplace = new ItemStack(Items.FERMENTED_SPIDER_EYE);
                ItemStack splashToReplace = new ItemStack(Items.GUNPOWDER);
                for (PotionHelper.MixPredicate moddedPotion : moddedPotions) {
                    if (moddedPotion.reagent.apply(extenderToReplace) && this.isExtended(((PotionType)moddedPotion.input).getEffects(), ((PotionType)moddedPotion.output).getEffects())) {
                        moddedPotion.reagent = extender;
                    }
                    if (moddedPotion.reagent.apply(strengthenerToReplace) && this.isStrong(((PotionType)moddedPotion.input).getEffects(), ((PotionType)moddedPotion.output).getEffects())) {
                        moddedPotion.reagent = strenthener;
                    }
                    if (moddedPotion.reagent.apply(inverterToReplace) && this.isInverted(((PotionType)moddedPotion.input).getEffects(), ((PotionType)moddedPotion.output).getEffects())) {
                        moddedPotion.reagent = inverter;
                    }
                    mixPredicates.add(moddedPotion);
                }
                List recipes = (List)ReflectionHelper.getPrivateValue(BrewingRecipeRegistry.class, null, (String[])new String[]{"recipes"});
                ListIterator<BrewingRecipe> iterator = recipes.listIterator();
                while (iterator.hasNext()) {
                    IBrewingRecipe recipe = (IBrewingRecipe)iterator.next();
                    if (!(recipe instanceof AbstractBrewingRecipe)) continue;
                    AbstractBrewingRecipe abstractRecipe = (AbstractBrewingRecipe)recipe;
                    if (abstractRecipe.isIngredient(extenderToReplace) && this.isExtended(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                        iterator.remove();
                        iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.WITCH_WART), abstractRecipe.getOutput()));
                        continue;
                    }
                    if (abstractRecipe.isIngredient(strengthenerToReplace) && this.isStrong(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                        iterator.remove();
                        iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE), abstractRecipe.getOutput()));
                        continue;
                    }
                    if (abstractRecipe.isIngredient(inverterToReplace) && this.isInverted(abstractRecipe.getInput(), abstractRecipe.getOutput())) {
                        iterator.remove();
                        iterator.add(new BrewingRecipe(abstractRecipe.getInput(), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POISON_SAC), abstractRecipe.getOutput()));
                        continue;
                    }
                    if (!abstractRecipe.isIngredient(splashToReplace) || !this.isSplash(abstractRecipe.getInput(), abstractRecipe.getOutput())) continue;
                    iterator.remove();
                    iterator.add(new BrewingRecipe(abstractRecipe.getInput(), new ItemStack(BWMItems.CREEPER_OYSTER), abstractRecipe.getOutput()));
                }
            }
        }
    }

    private boolean isModdedPotion(PotionHelper.MixPredicate<PotionType> predicate) {
        ResourceLocation registryName = ((PotionType)predicate.output).getRegistryName();
        return registryName == null || !registryName.getResourceDomain().toLowerCase().equals("minecraft") && !registryName.getResourceDomain().toLowerCase().equals("betterwithmods");
    }

    public boolean isExtended(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.getEffectsFromStack((ItemStack)potionA);
        List effectsB = PotionUtils.getEffectsFromStack((ItemStack)potionB);
        return this.isExtended(effectsA, effectsB);
    }

    private boolean isExtended(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);
        return this.isExtended(effectA, effectB);
    }

    private boolean isExtended(PotionEffect effectA, PotionEffect effectB) {
        return effectA.getPotion().equals(effectB.getPotion()) && effectA.getDuration() != effectB.getDuration();
    }

    public boolean isStrong(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.getEffectsFromStack((ItemStack)potionA);
        List effectsB = PotionUtils.getEffectsFromStack((ItemStack)potionB);
        return this.isStrong(effectsA, effectsB);
    }

    private boolean isStrong(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);
        return this.isStrong(effectA, effectB);
    }

    private boolean isStrong(PotionEffect effectA, PotionEffect effectB) {
        return effectA.getPotion().equals(effectB.getPotion()) && effectA.getAmplifier() < effectB.getAmplifier();
    }

    public boolean isInverted(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.getEffectsFromStack((ItemStack)potionA);
        List effectsB = PotionUtils.getEffectsFromStack((ItemStack)potionB);
        return this.isInverted(effectsA, effectsB);
    }

    private boolean isInverted(List<PotionEffect> effectsA, List<PotionEffect> effectsB) {
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = effectsA.get(0);
        PotionEffect effectB = effectsB.get(0);
        return this.isInverted(effectA, effectB);
    }

    private boolean isInverted(PotionEffect effectA, PotionEffect effectB) {
        return !effectA.getPotion().equals(effectB.getPotion());
    }

    public boolean isSplash(ItemStack potionA, ItemStack potionB) {
        List effectsA = PotionUtils.getEffectsFromStack((ItemStack)potionA);
        List effectsB = PotionUtils.getEffectsFromStack((ItemStack)potionB);
        if (effectsA.size() != 1 || effectsB.size() != 1) {
            return false;
        }
        PotionEffect effectA = (PotionEffect)effectsA.get(0);
        PotionEffect effectB = (PotionEffect)effectsB.get(0);
        return effectA.getPotion().equals(effectB.getPotion()) && potionB.getItem() instanceof ItemSplashPotion;
    }

    public Ingredient convertToPotionItem(ItemStack stack) {
        return StackIngredient.fromStacks(stack);
    }

    public Ingredient convertToPotionItem(Item item) {
        return Ingredient.fromItem((Item)item);
    }

    public Ingredient convertToPotionItem(Block block) {
        return Ingredient.fromItem((Item)Item.getItemFromBlock((Block)block));
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

