/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.tiles;

import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class TileMini
extends TileBasic {
    public IBlockState state;
    public BaseOrientation orientation;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = super.writeToNBT(compound);
        if (this.state != null) {
            NBTTagCompound texture = new NBTTagCompound();
            NBTUtil.writeBlockState((NBTTagCompound)texture, (IBlockState)this.state);
            tag.setTag("texture", (NBTBase)texture);
        } else {
            this.world.setBlockToAir(this.pos);
        }
        if (this.orientation != null) {
            tag.setInteger("orientation", this.orientation.ordinal());
        } else {
            this.world.setBlockToAir(this.pos);
        }
        return tag;
    }

    public abstract BaseOrientation deserializeOrientation(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound compound) {
        if (compound.hasKey("texture")) {
            this.state = NBTUtil.readBlockState((NBTTagCompound)compound.getCompoundTag("texture"));
        } else {
            this.world.setBlockToAir(this.pos);
        }
        this.orientation = this.deserializeOrientation(compound);
        super.readFromNBT(compound);
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, @Nullable EnumFacing face, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.loadFromStack(stack);
        if (this.getBlockType() instanceof BlockMini) {
            this.orientation = ((BlockMini)this.getBlockType()).getOrientationFromPlacement(placer, face, stack, hitX, hitY, hitZ);
        }
    }

    public void loadFromStack(ItemStack stack) {
        NBTTagCompound tag = stack.getSubCompound("texture");
        if (tag != null) {
            this.state = NBTUtil.readBlockState((NBTTagCompound)tag);
        }
    }

    public boolean changeOrientation(BaseOrientation newOrientation, boolean simulate) {
        if (this.orientation != newOrientation) {
            if (!simulate) {
                this.orientation = newOrientation;
                this.markBlockForUpdate();
                this.getWorld().notifyNeighborsRespectDebug(this.pos, this.getBlockType(), true);
            }
            return true;
        }
        return false;
    }

    public void markBlockForRenderUpdate() {
        this.world.markBlockRangeForRenderUpdate(this.pos, this.pos);
    }

    public void markBlockForUpdate() {
        IBlockState state = this.world.getBlockState(this.pos);
        this.world.notifyBlockUpdate(this.pos, state, state, 3);
    }

    public BaseOrientation getOrientation() {
        if (this.orientation == null) {
            return BaseOrientation.DEFAULT;
        }
        return this.orientation;
    }

    public IBlockState getState() {
        if (this.state == null) {
            return Blocks.AIR.getDefaultState();
        }
        return this.state;
    }

    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target, IBlockState state) {
        if (this.state != null && this.getBlockType() instanceof BlockMini) {
            return MiniBlocks.fromParent(this.getBlockType(), this.getState());
        }
        return ItemStack.EMPTY;
    }
}

