/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.client;

import betterwithmods.client.baking.IRenderComparable;
import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import betterwithmods.module.gameplay.miniblocks.tiles.TileMini;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;

public class MiniCacheInfo
implements IRenderComparable<MiniCacheInfo> {
    public final IBlockState state;
    public final BaseOrientation orientation;

    public MiniCacheInfo(IBlockState state, BaseOrientation orientation) {
        this.state = state;
        this.orientation = orientation;
    }

    public static MiniCacheInfo from(IBlockState state, BaseOrientation orientation) {
        return new MiniCacheInfo(state, orientation);
    }

    public static MiniCacheInfo from(TileMini mini) {
        return MiniCacheInfo.from(mini.state, mini.orientation);
    }

    public static MiniCacheInfo from(ItemStack mini) {
        NBTTagCompound tag = mini.getTagCompound();
        if (tag != null && tag.hasKey("texture")) {
            IBlockState texture = NBTUtil.readBlockState((NBTTagCompound)tag.getCompoundTag("texture"));
            return MiniCacheInfo.from(texture, BaseOrientation.DEFAULT);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MiniCacheInfo cacheInfo = (MiniCacheInfo)o;
        if (!this.state.equals(cacheInfo.state)) {
            return false;
        }
        return this.orientation == cacheInfo.orientation;
    }

    @Override
    public boolean renderEquals(MiniCacheInfo other) {
        return this.equals(other);
    }

    @Override
    public int renderHashCode() {
        return 31 * this.state.hashCode() + this.orientation.hashCode();
    }

    public BaseOrientation getOrientation() {
        if (this.orientation == null) {
            return BaseOrientation.DEFAULT;
        }
        return this.orientation;
    }

    public IBlockState getState() {
        if (this.state == null) {
            return Blocks.AIR.getDefaultState();
        }
        return this.state;
    }
}

